prjdir <- "S:/_operational/LANDIS-Demo"
dbdir <- "S:/_operational/LANDIS-Demo/Database"
sqmdir <- "I:/2022-CNU_zero/downscaling/hapcheon-100m/Downscale/SQM"
library(LANDISCC)
LANDISCC::Install.Required.Packages()

################################################################################
# 1. Edit user input part of SQMGrid.yaml and upload to EnvList
################################################################################
EnvList <- SetWorkingEnvironment(envfile = file.path(prjdir, "LANDISCC.yaml"))

#######################################
# 0. Create boundary image file
download.required.gis.data (EnvList)
create.landis.boundary.img (EnvList)
decide.ecoregion.elev.range (EnvList)

#######################################
# 1. Create Scenario Input File
create.landis.scenarios (EnvList)

#######################################
# 2. Create Ecoregion Input Files
create.landis.ecoregion.img (EnvList)
create.landis.ecoregion.txt (EnvList)
create.landis.ecoregion.climate.tif (EnvList)
create.landis.ecoregion.climate.txt (EnvList)

#######################################
# 3. Create Species Input File
create.landis.species (EnvList)

#######################################
# 4. Create PnET Input Files
create.landis.pnet.succession (EnvList)
create.landis.pnet.output.site (EnvList)
create.landis.pnet.species.parameters (EnvList)
create.landis.pnet.generic.species.parameters (EnvList)

#######################################
# 5. Create Initial Input Files
create.landis.initial.img (EnvList)
create.landis.initial.tif (EnvList)
create.landis.initial.txt (EnvList)

#######################################
# 6. Create Output Control File
create.landis.output.control (EnvList)

#######################################
# 7. Run LANDIS-II
run.landis.climate.change (EnvList)

#######################################
# 8. Summary WoodBiomass output
summary.landis.climate.change.max.biomass (EnvList)
summary.landis.climate.change.species.change (EnvList)
summary.landis.climate.change.species.area (EnvList)


