prjdir <- "I:/2022-IWMI_KOR/seamless/ObsStation-KMA"
dbdir <- "I:/2022-IWMI_KOR/Database"
grid.pnt_csvdir <- "I:/_operational/ObsGrid-ERA5Land-KOR/KOREA_adm1-era5pnt"
tscale <- "daily"
library(ObsStation)
ObsStation::Install.Required.Packages()

################################################################################
# 1. Edit user input part of ObsStation-daily.yaml and upload to EnvList
################################################################################
EnvList <- ObsStation::Set.Working.Environment(envfile = file.path(prjdir, "ObsStation-daily.yaml"), tscale)


################################################################################
# 1. Prepared daily or hourly weather data with AIMS format
########## Generate ERA5 for given station points
prjdir <- "I:/Database-KOR/kma_asos_daily"
era5dir <- "I:/Database/_CountryDB/KOR/era5_hourly_KR"
Era5VarNames <- c("prcp", "tmax", "tmin", "wspd", "rhum", "rsds")
# gisdir <- "I:/Database-KOR/kma_asos_daily/GISDB"
# stngisfile <- "asos_129stns.shp"
gisdir <- "I:/Database-KOR/kma_asos_daily/_gis_input"
stngisfile <- "Station-Info-all-129stns.shp"
pointopt <- TRUE
GisID <- "ID"
shift_hrs <- 9
ObsGrid::Extract.Era5 (prjdir, era5dir, Era5VarNames, gisdir, stngisfile, pointopt, GisID, shift_hrs)

GirdExtractDir <- EnvListObs$GirdExtractDir
varnames <- EnvListObs$Era5VarNames
gisdir <- EnvListObs$gisdir
stngisfile <- EnvListObs$stngisfile
GridStnDir <- "I:/Database-KOR/kma_asos_daily/Center_ERA5_KOR"
gridnm <- "ERA5"
grid_cent_info <- "era5-center-info.csv"
Convert.ERA5.Daily.Vars.To.Stns (GirdExtractDir, varnames, gridnm, gisdir, stngisfile, GridStnDir, grid_cent_info)


################################################################################
# 2. Preparing required data
################################################################################
### Observed weather Data (upload user own data based on sample file format)
Check.Data.Graph (EnvList, DataType="BC", NAline=T)
Check.Data.Graph (EnvList, DataType="VAL", NAline=T)

### Download ERA5 hourly NetCDF files (Only for sample run)
Download.Clipped.ERA5Land.Hourly(EnvList)
Download.Clipped.ERA5.Hourly(EnvList)
Update.ERA5Land.Hourly.NetCDF (EnvList)
Update.ERA5.Hourly (EnvList)

### Download National GIS data from DIVA-GIS (Use user-provided data)
Download.GIS.Data(EnvList)
Create.Mask.Tif.Shp.From.Bnd.Shp.n.Ref.Tif(EnvList)

### Extract ERA5 and ERA5Land grid center values
Extract.Era5 (EnvList, stngisfile=NULL, GisID=NULL)
Extract.Era5Land (EnvList, stngisfile=NULL, GisID=NULL)
Convert.ERA5Land.Daily.Vars.To.Stns (EnvList,  stngisfile=NULL)

################################################################################


##########################################
#### Obs data Quality Control
##########################################

stnfile = "Station-Info-all-129stns.csv"
QcVarNames = c("prec", "tmax", "tmin", "wspd", "rhum", "rsds", "tavg")
syear = 1981
eyear = 2021

datadir = "I:/Database-KOR/kma_asos_daily/01_extracted"
Data.Summary.Graph (datadir, stnfile, QcVarNames, syear, eyear)

Check.Observed.Data(EnvListObs)
Check.Data.Range(EnvListObs)
Check.Internal.Consistency(EnvListObs)
Gap.Filling.Neighbor.Stations.Monthly(EnvListObs)

datadir = "I:/Database-KOR/kma_asos_daily/05_GapFillNeighbor"
Data.Summary.Graph (datadir, stnfile, QcVarNames, syear, eyear)

Gap.Filling.Grid.Data.Monthly (EnvListObs)
Gap.Filling.Neighbor.Stations.Yearly (EnvListObs)
Gap.Filling.Grid.Data.Yearly (EnvListObs)

datadir = "I:/Database-KOR/kma_asos_daily/08_GapFillGrid2"
ObsGrid::Data.Summary.Graph (datadir, stnfile, QcVarNames, syear, eyear)

library(korea)
library(ObsGrid)

