# rm(list=ls())
prjdir <- "I:/2022-IWMI_KOR/seamless/ObsStation-KMA"
dbdir <- "I:/2022-IWMI_KOR/Database"
grid.pnt_csvdir <- "I:/_operational/ObsGrid-ERA5Land-KOR/KOREA_adm1-era5pnt"
tscale <- "hourly"
library(ObsStation)
Install.Required.Packages()

################################################################################
### 1. Edit user input part of ObsStation.yaml and upload to EnvList
################################################################################
EnvList <- Set.Working.Environment(tscale)

###############################################################################
#### 2. Extract ERA5 hourly from daily ERA5 for ASOS stations
###############################################################################
Convert.ERA5Land.Daily.Vars.To.Stns (EnvList,  stngisfile=NULL)


GirdExtractDir <- "I:/Database-KOR/era5_extract/asos_kma_129stns_kor/01_extract_vars"
varnames <- c("prcp", "tmax", "tmin", "wspd", "rhum", "rsds")
gridnm <- "ERA5"
gisdir <- "I:/Database-KOR/GISDB/4326-Korea"
stngisfile <- "asos_kma_129stns_kor.shp"
GridStnDir <- "I:/Database-KOR/era5_extract/asos_kma_129stns_kor"
grid_stn_info <- "era5_kma_129stns_kor.csv"
GMT <- 9

###############################################################################
#### 2.1. Extract ASOS daily for hourly gapfilling
### Only South KR has information "강수 계속시간(hr)", "1시간 최다강수량(mm)", "1시간 최다 강수량 시각(hhmi)","최저기온(°C)", "최저기온 시각(hhmi)"...
###############################################################################
prjdir <- "I:/Database-KOR/kma_asos_daily"
SKRdir <- "I:/Database-KOR/kma_asos_daily/download-SKR"
stndir <- "I:/Database-KOR/kma_asos_daily/01_extracted"
SKRstnfile <- "Station-Info-sorth-102stns.csv"
korea::kma.asos.daily.update.for.hourly.gapfill (prjdir, SKRdir, stndir, SKRstnfile)

###############################################################################
#### 2.2. gapfill rsds, shine=0 using sunrise(and sunset) time
### sunset+2 ~ sunrise-1: rsds <- 0
###############################################################################
prjdir <- "I:/Database-KOR/kma_asos_hourly"
hourly_dir <- "I:/Database-KOR/kma_asos_hourly/04_GapFillUsingDailyobs"
stndir <- "I:/Database-KOR/kma_asos_hourly/01_extracted"
stnfile <- "Station-Info-all-129stns.csv"
SunlightTimes.For.RsdsShine (prjdir, hourly_dir, stndir, stnfile)

###############################################################################
#### 3. Gapfilling hourly ASOS data
### Check.Hourly.Observed.Data: fully date
### 04_GapFillUsingDailyobs
### -- caution 1. daily prec is generated by 1:00 ~ next day 0:00
### -- caution 2. floating point calculation problem, so 'a==b' -> 'abs(a-b)<0.01'
###############################################################################
prjdir <- "I:/Database-KOR/kma_asos_hourly"
stndir <- file.path(prjdir, "01_extracted")
stnfile <- "Station-Info-all-129stns.csv"
QcVarNames <- c("prec","temp","wspd","rhum","rsds","shine","cloud")

extracted_dir <- file.path(prjdir, "01_extracted")
CheckObsDate_dir <- file.path(prjdir, "02_CheckObsData")
CheckDataRange_dir <- file.path(prjdir, "03_CheckDataRange")
Dailyobs_dir <- "I:/Database-KOR/kma_asos_daily/01_extracted"
GapFillUsingDailyobs_dir <- file.path(prjdir, "04_GapFillUsingDailyobs")
DailyobsForHourlyGapfill_dir <- "I:/Database-KOR/kma_asos_daily/01_extracted_for_hourly_gapfill"
GenerateUsingDailyobs_dir <- file.path(prjdir, "05_GenerateUsingDailyobs")
GapFillUnder6hr_dir <- file.path(prjdir, "06_GapFillUnder6hr")
GapFillUnder6hr_edit_dir <- file.path(prjdir, "06_GapFillUnder6hr_edit")
HourlyEra5_dir <- "I:/Database-KOR/era5_extract/asos_kma_129stns_kor/04_station_hourly"
GapFillUsingEra5_dir <- file.path(prjdir, "07_GapFillUsingEra5")

ObsGrid::Check.Hourly.Observed.Date (prjdir, extracted_dir, CheckObsDate_dir, stndir, stnfile)
ObsGrid::Check.Data.Graph.Full (CheckObsDate_dir, stndir, stnfile, QcVarNames, NAdraw=-99) ### Data check using graph
ObsGrid::Check.Hourly.Data.Range (prjdir, CheckObsDate_dir, CheckDataRange_dir, stndir, stnfile)
ObsGrid::Gap.Fill.Using.Dailyobs (prjdir, CheckDataRange_dir, Dailyobs_dir, GapFillUsingDailyobs_dir, stndir, stnfile, QcVarNames)
ObsGrid::Generate.Using.Dailyobs (prjdir, GapFillUsingDailyobs_dir, DailyobsForHourlyGapfill_dir, GenerateUsingDailyobs_dir, stndir, stnfile, QcVarNames)
ObsGrid::Gap.Filling.Under6hr (prjdir, GenerateUsingDailyobs_dir, GapFillUnder6hr_dir, stndir, stnfile, QcVarNames)
ObsGrid::Check.Hourly.Observed.Date.manual (prjdir, GapFillUnder6hr_dir, GapFillUnder6hr_edit_dir, stndir, stnfile)
ObsGrid::GapFillUsingEra5 (prjdir, GapFillUnder6hr_edit_dir, HourlyEra5_dir, GapFillUsingEra5_dir, stndir, stnfile, QcVarNames)

stnfile_SKR <- "Station-Info-101stns.csv"
ObsGrid::Check.Data.Graph.Full (GapFillUsingEra5_dir, GapFillUsingEra5_dir, stnfile_SKR, QcVarNames, NAdraw=-99) ### Data check using graph

# Dailyobs_dir2 <- "I:/Database-KOR/kma_asos_daily/08_GapFillGrid2"
# GapFillUsingDailyobs_dir2 <- file.path(prjdir, "05_GapFillUsingDailyobs2")
# ObsGrid::Gap.Fill.Using.Dailyobs (prjdir, GapFillUsingDailyobs_dir, Dailyobs_dir2, GapFillUsingDailyobs_dir2, stndir, stnfile, QcVarNames)










###############################################################################
### 2. Download (or update) hourly ASOS data (data.kma.go.kr)
###############################################################################
library(korea)
ASOShourlydir <- "I:/Database-KOR/asos_kma/hourly"
SKRdir <- file.path(ASOShourlydir, "download-SKR")
NKRdir <- file.path(ASOShourlydir, "download-NKR")
SKRstnfile <- "Station-Info-sorth-102stns.csv"
NKRstnfile <- "Station-Info-north-27stns.csv"
# stnfile <- "Station-Info-all-129stns.csv"
extracted_dir <- file.path(ASOShourlydir, "01_extracted")
QcVarNames <- c("prec","temp","wspd","rhum","rsds","shine","cloud")

# korea::check.csv.colnms (SKRdir, pattern="asos_hourly_*.csv") #check raw data column names
# korea::check.csv.colnms (NKRdir, pattern="asos_hourly_*.csv") #check raw data column names
korea::kma.asos.hourly.update (ASOShourlydir, SKRdir, SKRdir, SKRstnfile)
korea::kma.asos.hourly.update.north (ASOShourlydir, NKRdir, NKRdir, NKRstnfile)
# ObsGrid::Check.Data.Graph.Full (extracted_dir, extracted_dir, stnfile, QcVarNames, NAline=F) #check raw data using graph
# korea::check.csv.colnms(extracted_dir, "asos*.csv") #check extracted data column names



prjdir <- "I:/2022-IWMI_KOR/seamless/ObsStation-KMA"
dbdir <- "I:/2022-IWMI_KOR/Database"
grid.pnt_csvdir <- "I:/_operational/ObsGrid-ERA5Land-KOR/KOREA_adm1-era5pnt"
tscale <- "daily"
library(ObsStation)
ObsStation::Install.Required.Packages()

################################################################################
# 1. Edit user input part of SQMGrid.yaml and upload to EnvList
################################################################################
EnvList <- ObsStation::SetWorkingEnvironment(envfile = file.path(prjdir, "ObsStation.yaml"))

################################################################################
# 1. Prepared daily or hourly weather data with AIMS format
########## Generate ERA5 for given station points
prjdir <- "I:/Database-KOR/kma_asos_daily"
era5dir <- "I:/Database/_CountryDB/KOR/era5_hourly_KR"
Era5VarNames <- c("prcp", "tmax", "tmin", "wspd", "rhum", "rsds")
# gisdir <- "I:/Database-KOR/kma_asos_daily/GISDB"
# stngisfile <- "asos_129stns.shp"
gisdir <- "I:/Database-KOR/kma_asos_daily/_gis_input"
stngisfile <- "Station-Info-all-129stns.shp"
pointopt <- TRUE
GisID <- "ID"
shift_hrs <- 9
ObsGrid::Extract.Era5 (prjdir, era5dir, Era5VarNames, gisdir, stngisfile, pointopt, GisID, shift_hrs)

GirdExtractDir <- EnvListObs$GirdExtractDir
varnames <- EnvListObs$Era5VarNames
gisdir <- EnvListObs$gisdir
stngisfile <- EnvListObs$stngisfile
GridStnDir <- "I:/Database-KOR/kma_asos_daily/Center_ERA5_KOR"
gridnm <- "ERA5"
grid_cent_info <- "era5-center-info.csv"
Convert.ERA5.Daily.Vars.To.Stns (GirdExtractDir, varnames, gridnm, gisdir, stngisfile, GridStnDir, grid_cent_info)


##########################################
#### Obs data Quality Control
##########################################

stnfile = "Station-Info-all-129stns.csv"
QcVarNames = c("prec", "tmax", "tmin", "wspd", "rhum", "rsds", "tavg")
syear = 1981
eyear = 2021

datadir = "I:/Database-KOR/kma_asos_daily/01_extracted"
Data.Summary.Graph (datadir, stnfile, QcVarNames, syear, eyear)

Check.Observed.Data(EnvListObs)
Check.Data.Range(EnvListObs)
Check.Internal.Consistency(EnvListObs)
Gap.Filling.Neighbor.Stations.Monthly(EnvListObs)

datadir = "I:/Database-KOR/kma_asos_daily/05_GapFillNeighbor"
Data.Summary.Graph (datadir, stnfile, QcVarNames, syear, eyear)

Gap.Filling.Grid.Data.Monthly (EnvListObs)
Gap.Filling.Neighbor.Stations.Yearly (EnvListObs)
Gap.Filling.Grid.Data.Yearly (EnvListObs)

datadir = "I:/Database-KOR/kma_asos_daily/08_GapFillGrid2"
ObsGrid::Data.Summary.Graph (datadir, stnfile, QcVarNames, syear, eyear)

library(korea)
library(ObsGrid)

