prjdir <- "I:/2024-SAMAN_monitoring"
library(ObsStation)
ObsStation::Install.Required.Packages()
ObsStation::read.functions()

# 0. Edit user input part of ObsStation-iwmp.yaml and upload to EnvList
EnvList <- ObsStation::Set.Working.Environment(obs.type="iwmp", envfile = file.path(prjdir, "ObsStation-iwmp.yaml"))

# 1. Export data from IWMP (http://monitoring.iwmi.co.kr/) by manually

# 2. Extract and change format for each station
iwmp.convert.exported.data.to.station.data (EnvList)

# 3. QC: remove outlier and interpolate NAs
iwmp.quality.control.station.data (EnvList)

# 4. Combine and summarize with graphs
iwmp.combined.summary.and.graphs (EnvList)
