      PROGRAM FFA
C     ******************************************************************
C     PROGRAM OF FLOOD FREQUENCY ANALYSIS
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     ORIGINAL : MAY, 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER(ICDF=0,IX=1,ALPHA=0.05D0,IPP=0,NDIST=10,IRET=20,NOD=100)
      DOUBLE PRECISION X(NOD),XP(NOD),
	1          CHICOM(NDIST),CHITAB(NDIST),KSCOM(NDIST),KSTAB(NDIST),
	2          PAR1(NDIST),PAR2(NDIST),PAR3(NDIST),
     3          PDFS(NOD),CDFS(NOD),ECDF(NOD),CDFC(NOD),CDFD(NDIST),
     4          RETP(IRET),RETPX(IRET),QUAX(NDIST,IRET)
      DIMENSION JUDGCH(NDIST),JUDGKS(NDIST),KVALID(NDIST),IPAR(NDIST)
      CHARACTER*4 DISTB(NDIST), JUDG(0:1)
      CHARACTER*10 SITENAME
      CHARACTER*100 INF, OUTF
      DATA IPAR/2,3,3,2,2,3,3,2,3,2/
      DATA JUDG/'N.G.','O.K.'/      
      DATA DISTB/'GAM2','GAM3','GEV ','GUM ','LN2 ','LN3 ','LP3 ','WBU2'
	1           ,'WBU3','NOR '/
      IBIAS = 2
      CALL GETARG(1, INF)
	!WRITE(*,*)' INPUT FILE : '
      !READ (*,*)  INF
      CALL GETARG(2, OUTF)
	!RITE(*,*)' OUTPUT FILE : '
      !EAD (*,*)  OUTF
C
      OPEN (UNIT=5,FILE=INF,STATUS='UNKNOWN')
      OPEN (UNIT=6,FILE=OUTF,STATUS='UNKNOWN')

C======================================================================
C     READ THE INITAIAL DATA AND THEN CALCULATE BASIC STATISTICS
C======================================================================
      READ(5,810) SITENAME
      READ(5,811) NDATA
	READ(5,811) NRET
  810 FORMAT(A6)
  811 FORMAT(I2)
	IF(NRET.GE.1) THEN
        IF(NRET.GT.20) NRET = 20
	  READ(5,*) (RETP(I), I = 1, NRET)
      ELSE
         NRET = 10
	   RETP(1) = 2.0D0
	   RETP(2) = 5.0D0
	   RETP(3) = 10.0D0
	   RETP(4) = 20.0D0
	   RETP(5) = 30.0D0
	   RETP(6) = 50.0D0
	   RETP(7) = 80.0D0
	   RETP(8) = 100.0D0
         RETP(9) = 200.0D0
         RETP(10)= 500.0D0
	END IF
C
      READ(5,*) (X(J), J = 1, NDATA)
      CALL MOMEN1(NDATA,X,EV,SD,CV,CS,IBIAS)
	WRITE(6,812)
  812 FORMAT(/,
     +'  ************************************************************'/,
     +'  *                                                          *'/,
     +'  *  PROGRAM OF FLOOD FREQUENCY ANALYSIS                     *'/,
     +'  *  by UNIVERSITY OF SEOUL                                  *'/,
     +'  *  (Tel: 02-2210-2764, e-mail: ymoon@uos.ac.kr             *'/,
     +'  *                                                          *'/,
     +'  *  VER 1.0                                                 *'/,
     +'  *                                                          *'/,
     +'  ************************************************************')      
C
      WRITE(6,813) SITENAME
  813 FORMAT(//,
     +'      ****************************************',/
     +'      *     BASIC STATISTICS   -  ',A10,' *',/
     +'      ****************************************',//,
     +'      MEAN',4X,'STA. DEV.',3X,'SKEWNESS.',/)
      WRITE(6,814)EV,SD,CS
  814 FORMAT(F10.1,3X,F8.1,4X,F7.3)
C
      DO 110 J = 1,NDATA
         XP(J) = DLOG(X(J))
  110 CONTINUE
      CALL SORT(NDATA,X,0)
      CALL SORT(NDATA,XP,0)
C
	XMAX=X(NDATA)
	XMIN=X(1)
	XTMAX=XP(NDATA)
	XTMIN=XP(1)

C======================================================================        
C ESTIMATE PARAMETERS   
C======================================================================        

        CALL PARGAM (NDATA,X,PAR1(1),PAR3(1),PAR2(1),
     1               IPAR(1),IBIAS,XMIN,XMAX,KVALID(1))
        CALL PARGAM (NDATA,X,PAR1(2),PAR3(2),PAR2(2),
     2               IPAR(2),IBIAS,XMIN,XMAX,KVALID(2))
        CALL PARGEV (NDATA,X,PAR1(3),PAR3(3),PAR2(3),IBIAS,ITYP,
     3               XMAX,XMIN,KVALID(3),CS)
        CALL PARGUM (NDATA,X,PAR1(4),PAR3(4),IBIAS,XMAX,XMIN,
     4               KVALID(4))
        CALL PARLOGN (NDATA,X,PAR1(5),PAR3(5),PAR2(5),IPAR(5),
     5               XMIN,XMAX,KVALID(5),IBIAS)
        CALL PARLOGN (NDATA,X,PAR1(6),PAR3(6),PAR2(6),IPAR(6),
     6               XMIN,XMAX,KVALID(6),IBIAS)
C        CALL PARLP3  (NDATA,XP,PAR1(7),PAR3(7),PAR2(7),GCS,
C     7               XTMAX,XTMIN,KVALID(7),IBIAS)
        CALL PARWBU (NDATA,X,PAR1(8),PAR3(8),PAR2(8),IPAR(8),2,
     8               XMAX,XMIN,KVALID(8),CS)
        CALL PARWBU (NDATA,X,PAR1(9),PAR3(9),PAR2(9),IPAR(9),2,
     9               XMAX,XMIN,KVALID(9),CS)
C======================================================================     
C      GOODNESS OF FIT TEST FOR EACH DISTRIBUTION
C======================================================================     

      WRITE(6,820) 
  820 FORMAT(//
     +'      *******************************************',/
     +'      *         GOODNESS OF FIT TESTS           *',/
     +'      *******************************************',/)
      KKD = 0
      WRITE(6,821)  
  821 FORMAT(14X,'CHI-SQUARE',17X,'KOLMOGOROV-SMIRNOV',/
     +       9X,'COMPUTED',3X,'TABLE',3X,'CHECK',
     +       5X,'COMPUTED',3X,'TABLE',3X,'CHECK'/)
C
      NCL  = 1.0D0 + 3.322D0*DLOG10(DFLOAT(NDATA)) + 1.0D0
      NCL1 = NCL-1
      CALL SORT (NDATA,X,0)
C
      DO 210 J=1,2
      CALL QUAGAM (PAR1(J),PAR3(J),PAR2(J),NCL1,CDFC,CLASS1,0,IPAR(J))
	CALL DISGAM (NDATA,X,PAR1(J),PAR3(J),PAR2(J),XIN,PDFS,CDFS,IX)
      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
     1            CHITAB(J),JUDGCH(J))
      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
     1            JUDGKS(J))
      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
     2        JUDG(JUDGKS(J))
  210	CONTINUE
C
      J=3
	CALL QUAGEV (PAR1(J),PAR3(J),PAR2(J),NCL1,CDFC,CLASS1,0)
      CALL DISGEV (NDATA,X,PAR1(J),PAR3(J),PAR2(J),PDFS,CDFS,IX)
      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
     1            CHITAB(J),JUDGCH(J))
      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
     1            JUDGKS(J))
      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
     2        JUDG(JUDGKS(J))
C
      J=4
	CALL QUAGUM (PAR1(J),PAR3(J),NCL1,CDFC,CLASS1,0)
      CALL DISGUM (NDATA,X,PAR1(J),PAR3(J),PDFS,CDFS,IX)
      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
     1            CHITAB(J),JUDGCH(J))
      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
     1            JUDGKS(J))
      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
     2        JUDG(JUDGKS(J))
C
      DO 220 J=5,6
	CALL QUALOG (PAR1(J),PAR3(J),PAR2(J),NCL1,CDFC,CLASS1,0)
      CALL DISLOG (NDATA,X,PAR1(J),PAR3(J),PAR2(J),PDFS,CDFS,IX)
      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
     1            CHITAB(J),JUDGCH(J))
      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
     1            JUDGKS(J))
      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
     2        JUDG(JUDGKS(J))
  220	CONTINUE
C
C      DO 223 J=7
C      CALL QUAGAM (PAR1(J),PAR3(J),PAR2(J),NCL1,CDFC,CLASS1,0,IPAR(J))
C	CALL DISGAM (NDATA,XP,PAR1(J),PAR3(J),PAR2(J),XIN,PDFS,CDFS,IX)
C      CALL CHITST (NDATA,XP,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
C     1            CHITAB(J),JUDGCH(J))
C      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
C     1            JUDGKS(J))
C      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
C     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
C     2        JUDG(JUDGKS(J))
C  223	CONTINUE
CC
C      J=7
C	IF(PAR2(J).GT.1000.0D0) GOTO 223
C      IF (PAR3(J).GT.0.0D0) THEN
C          XINLP = 0.0D0
C          DO 221 K = 1,NDATA
C  221     XINLP = DMAX1(XINLP,XP(K))
C      ELSE IF (PAR3(J).LT.0.0D0) THEN
C          XINLP = X(1)
C          DO 222 K = 2,NDATA
C  222       XINLP = DMIN1(XINLP,XP(K))
C      END IF
C      CALL QUALP (PAR1(J),PAR3(J),PAR2(J),NCL1,CDFC,CLASS1,ICDF,XINLP)
C      CALL DISLP (NDATA,XP,PAR1(J),PAR3(J),PAR2(J),XINLP,PDFS,CDFS,
C     1            IX)
C      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
C     1            CHITAB(J),JUDGCH(J))
C      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
C     1            JUDGKS(J))
C      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
C     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
C     2        JUDG(JUDGKS(J))
C  223 CONTINUE
CC
      DO 230 J=8,9
	if(x(1).lt.PAR1(j)) goto 231
      CALL QUAWBU (PAR1(J),PAR3(J),PAR2(J),IPAR(J),NCL1,CDFC,
     1             CLASS1,0)
      CALL DISWBU (NDATA,X,PAR1(J),PAR3(J),PAR2(J),IPAR(J),PDFS,
     1             CDFS,IX)
      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
     1            CHITAB(J),JUDGCH(J))
      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
     1            JUDGKS(J))
  231 WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
     2        JUDG(JUDGKS(J))
  230 CONTINUE	
C
      J=10
      CALL QUANOR (EV,SD,NCL1,CDFC,CLASS1,0)
      CALL DISNOR (NDATA,X,EV,SD,PDFS,CDFS,IX)
      CALL CHITST (NDATA,X,NCL1,IPAR(J),CLASS1,CDFC,ALPHA,CHICOM(J),
     1            CHITAB(J),JUDGCH(J))
      CALL KSTST  (NDATA,CDFS,IPP,ECDF,ALPHA,KSCOM(J),KSTAB(J),
     1            JUDGKS(J))
      WRITE(6,822)DISTB(J),CHICOM(J),CHITAB(J),
     1        JUDG(JUDGCH(J)),KSCOM(J),KSTAB(J),
     2        JUDG(JUDGKS(J))
C
  822 FORMAT(3X,A4,2X,F7.2,2X,F7.2,5X,A4,6X,F5.3,4X,F5.3,5X,A4)
C
C======================================================================     
C QUANTILE ESTIMATION
C======================================================================     
  
      WRITE(6,830) 
  830 FORMAT(//
     +'      *******************************************',/
     +'      *          QUANTILE ESTIMATION            *',/
     +'      *******************************************',/)
C-----------------------------------------------------------------------
      DO 310 I1 = 1, NRET
         CDFD(I1) = (RETP(I1)-1.0D0)/RETP(I1)
  310 CONTINUE
      DO 320 J=1,2
      CALL QUAGAM (PAR1(J),PAR3(J),PAR2(J),NRET,CDFD,RETPX,1,
     1              IPAR(J))
      DO 321 K = 1, NRET
      QUAX(J,K) = RETPX(K)
  321 CONTINUE
  320 CONTINUE
C
	J=3
      CALL QUAGEV (PAR1(J),PAR3(J),PAR2(J),NRET,CDFD,RETPX,1)
      DO 330 K = 1, NRET
      QUAX(J,K) = RETPX(K)   
  330 CONTINUE
C
      J=4  
      CALL QUAGUM (PAR1(J),PAR3(J),NRET,CDFD,RETPX,1)
      DO 340 K = 1, NRET
      QUAX(J,K) = RETPX(K)
  340 CONTINUE
C
      DO 350 J=5,6
      CALL QUALOG (PAR1(J),PAR3(J),PAR2(J),NRET,CDFD,RETPX,1)
      DO 351 K = 1, NRET
      QUAX(J,K) = RETPX(K)
  351 CONTINUE
  350 CONTINUE
C
C      J=7
C      CALL QUAGAM (PAR1(J),PAR3(J),PAR2(J),NRET,CDFD,RETPX,1,
C     1              IPAR(J))
C      DO 360 K = 1, NRET
C      QUAX(J,K) = RETPX(K)
C  360 CONTINUE
CC
C	J=7
CC	IF(PAR2(J).GT.1000.) GOTO 361
C     CALL QUALP  (PAR1(J),PAR3(J),PAR2(J),NRET,CDFD,RETPX,1,XINLP)
C      DO 360 K = 1, NRET
C      QUAX(J,K) = DEXP(RETPX(K))
C  360 CONTINUE
C  361 CONTINUE
CC
      DO 370 J=8,9
	IF(X(1) .LT. PAR1(J)) EXIT
      CALL QUAWBU (PAR1(J),PAR3(J),PAR2(J),IPAR(J),NRET,CDFD,
     1             RETPX,1)
      DO 371 K = 1, NRET
      QUAX(J,K) = RETPX(K)
  371 CONTINUE
  370 CONTINUE
C
      J=10  
      CALL QUANOR (EV,SD,NRET,CDFD,RETPX,1)
      DO 380 K = 1, NRET
      QUAX(J,K) = RETPX(K)
  380 CONTINUE
C
C      WRITE(6,831)(DISTB(J1), J1 = 1, NDIST)
      WRITE(6,831)(DISTB(J1), J1 = 1,6),(DISTB(J1),J1=8, NDIST)

      DO 410 K1 = 1, NRET
C     WRITE(6,832) RETP(K1),(QUAX(J,K1),J=1,NDIST)
	WRITE(6,832) RETP(K1),(QUAX(J,K1),J=1,6),(QUAX(J,K1),J=8,NDIST)
  410 CONTINUE
c
  831 FORMAT(//,'RETURN',11(4X,A4),/,'PERIOD',2X,11('  DIST. ')/) 
  832 FORMAT (F6.1,1X,11F8.1)  
      STOP
      END
C
      SUBROUTINE DISNOR (NS,X,PAR1,PAR3,PDF,CDF,IX)
C     ******************************************************************
C     PDF AND CDF OF THE NORMAL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : MARCH 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(NS), PDF(NS), CDF(NS)
      DATA UMIN,UMAX/-3.5D0,3.5D0/
      CONS = 1.0D0/DSQRT(6.2831852D0)
      DO 120 I = 1,NS
         U = (X(I) - PAR1)/PAR3
         PDF(I) = CONS * DEXP( - 0.5D0 * U ** 2)
         V = 1.0D0/(1.0D0 + 0.2316419D0 * DABS(U))
         CDF(I) = 1.0D0 - PDF(I) * V * (0.3193815D0 + V * (-0.3565638D0
     +           + V * (1.781478D0+V*(-1.821256D0+V*1.330274D0))))
         IF (U.LT.0) CDF(I) = 1.0D0 - CDF(I)
  120 PDF(I) = PDF(I)/PAR3
      RETURN
      END
C
      SUBROUTINE DISGAM (N,X,PAR1,PAR3,PAR2,XIN,PDF,CDF,IX)
C     ******************************************************************
C     PROBABILITY DENSITY FUNCTION AND CDF OF THE GAMMA DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : MARCH 1987
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), PDF(N), CDF(N)
      IF (PAR3.LT.0.0D0) GOTO 160
      IF (IX.GT.0) GOTO 110
      DELX = (XIN - PAR1)/(N - 1)
      DO 100 I = 1,N
  100 X(I) = PAR1 + (I - 1.0D0) * DELX
  110 IF (X(1).GT.PAR1) GOTO 120
      PDF(1) = 0.0D0
      CDF(1) = 0.0D0
      GOTO 130
  120 PDF(1) = PDFGAM(X(1),PAR1,PAR3,PAR2)
      CDF(1) = CDFGAM(X(1),PAR1,PAR3,PAR2,ICNV)
  130 IF (N.EQ.1) GOTO 230
      DO 150 I = 2,N
         XI = X(I)
         IF (XI.GT.PAR1) GOTO 140
         PDF(I) = 0.0D0
         CDF(I) = 0.0D0
         GOTO 150
  140    PDF(I) = PDFGAM(XI,PAR1,PAR3,PAR2)
         CDF(I) = CDFGAM(XI,PAR1,PAR3,PAR2,ICNV)
  150 CONTINUE
      GOTO 230
  160 IF (IX.GT.0) GOTO 180
      PDF(N) = 0.0D0
      CDF(N) = 1.0D0
      DELX = DABS((PAR1 - XIN)/DFLOAT(N - 1))
      DO 170 I = 1,N
  170 X(I) = XIN + DFLOAT(I - 1) * DELX
      GOTO 200
  180 IF (X(N).LT.PAR1) GOTO 190
      PDF(N) = 0.0D0
      CDF(N) = 1.0D0
      GOTO 200
  190 PDF(N) = PDFGAM(X(N),PAR1,PAR3,PAR2)
      CDF(N) = CDFGAM(X(N),PAR1,PAR3,PAR2,ICNV)
  200 IF (N.EQ.1) GOTO 230
      DO 220 I = 2,N
         IC = N - I + 1
         XI = X(IC)
         IF (XI.LT.PAR1) GOTO 210
         PDF(IC) = 0.0D0
         CDF(IC) = 1.0D0
         GOTO 220
  210    PDF(IC) = PDFGAM(XI,PAR1,PAR3,PAR2)
         CDF(IC) = CDFGAM(XI,PAR1,PAR3,PAR2,ICNV)
  220 CONTINUE
  230 RETURN
      END
C
      SUBROUTINE DISGUM (N,X,PAR1,PAR3,PDF,CDF,IX)
C     ******************************************************************
C     PROBABILITY DENSITY FUNCTION AND CDF OF THE GUMBEL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATA ORIGINAL VERSION :  MARCH 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), PDF(N), CDF(N)
      DATA CDFMIN,CDFMAX/0.001,0.999/
      IF (IX.GT.0) GOTO 130
      XMAX = PAR1 - PAR3 * DLOG( - DLOG(CDFMAX))
      XMIN = PAR1 - PAR3 * DLOG( - DLOG(CDFMIN))
      DELX = (XMAX - XMIN)/N
      DO 110 I = 1,N
  110 X(I) = XMIN + (I - 1) * DELX
  130 DO 140 I = 1,N
         CDF(I) = EXP( - EXP( - (X(I) - PAR1)/PAR3))
  140 PDF(I) = EXP( - (X(I) - PAR1)/PAR3) * CDF(I)/PAR3
      RETURN
      END
C
      SUBROUTINE DISGEV (N,X,PAR1,PAR3,PAR2,PDF,CDF,IX)
C     ******************************************************************
C     PROBABILITY DENSITY FUNCTION AND CDF OF THE GEV DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  MARCH 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), PDF(N), CDF(N)
      DATA TRESH/0.00001D0/
      IF (ABS(PAR2).LT.TRESH) GOTO 200
      C1 = PAR3/PAR2
      C2 = 1.0D0/PAR2
      ITYP = 2
      IF (IX.GT.0) GOTO 140
      IF (PAR2.GT.0.) GOTO 100
      XMIN = PAR1 + C1
      XMAX = C1 * (1.0D0 - ( - DLOG(0.999D0)) ** PAR2) + PAR1
      GOTO 110
  100 XMAX = PAR1 + C1
      XMIN = C1 * (1.0D0 - ( - DLOG(0.001D0)) ** PAR2) + PAR1
  110 N1 = N/3
      N2 = N - N1
      DELX1 = (PAR1 - XMIN)/N1
      DO 120 I = 1,N1
  120 X(I) = XMIN + (I - 1) * DELX1
      DELX2 = (XMAX - PAR1)/(N2 - 1)
      DO 130 I = 1,N2
         J = N1 + I
  130 X(J) = PAR1 + (I - 1) * DELX2
  140 DO 160 I = 1,N
         XE1 = 1.0D0 - (X(I) - PAR1)/C1
         IF (XE1.LE.TRESH) GOTO 150
         XE2 = XE1 ** C2
         IF (XE2.GT.230.0D0) GOTO 150
         CDF(I) = EXP( - XE2)
         PDF(I) = (XE2/XE1) * CDF(I)/PAR3
         GOTO 160
  150    PDF(I) = 0.0D0
         CDF(I) = 0.0D0
         IF (PAR2.GT.0.0D0) CDF(I) = 1.0D0
  160 CONTINUE
      IF (PAR2.GT.0.) ITYP = 3
      RETURN
  200 WRITE(6,210) XSH,TRESH
  210 FORMAT (//1X,'XSH=',F13.6,2X,'SINCE XSH IS SMALLER THAN',F9.6,1X,
     1/,1X,'IT IS BETTER TO USE THE SUBROUTINE DISGUM FOR THE GUMBEL DIS
     2TRIBUTION',/)
	RETURN
      END
C
      SUBROUTINE DISLOG(N,X,PAR1,PAR3,PAR2,PDF,CDF,IX)
C     ******************************************************************
C     PROBABILITY DENSITY FUNCTION AND CDF OF THE LOGNORMAL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  APRIL 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), PDF(N), CDF(N), CK(2)
      DATA UMAX,CK/3.5,0.4342944819,1.0/
      CONS = 1./SQRT(6.2831852)
      IPAR = 3
      IF (IX.NE.0) GOTO 110
      XMAX = PAR1 + EXP(PAR3 + UMAX * PAR2)
      DELX = (XMAX - PAR1)/(N - 1)
      DO 100 I = 1,N
  100 X(I) = PAR1 + (I - 1) * DELX
  110 DO 130 I = 1,N
         IF (X(I).GT.PAR1) GOTO 120
         PDF(I) = 0.0
         CDF(I) = 0.0
         GOTO 130
  120    U = (DLOG(X(I) - PAR1) - PAR3)/PAR2
         PDF(I) = CONS * EXP( - 0.5 * U ** 2)
         V = 1./(1. + 0.2316419 * ABS(U))
         CDF(I) = 1. - PDF(I) * V * (0.3193815 + V * ( - 0.3565638 + V *
     1    (1.781478 + V * ( - 1.821256 + V * 1.330274))))
         IF (U.LT.0) CDF(I) = 1. - CDF(I)
         PDF(I) = CK(2) * PDF(I)/(PAR2 * (X(I) - PAR1))
  130 CONTINUE
      IF (PAR1.EQ.0.) IPAR = 2
      RETURN
      END
C
      SUBROUTINE DISWBU (N,X,PAR1,PAR3,PAR2,IPAR,PDF,CDF,IX)
C     ******************************************************************
C     PROBABILITY DENSITY FUNCTION AND CDF OF THE WEIBULL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATA ORIGINAL VERSION :  NOV. 1992
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), PDF(N), CDF(N)
      DATA CDFMIN,CDFMAX/0.001D0,0.999D0/
      IF (IPAR.EQ.2) PAR1 = 0.0D0
      IF (IX.GT.0) GOTO 20
      XMAX = PAR1 + PAR3 * (-DLOG(1.0 - CDFMAX))**(1.0/PAR2)
      XMIN = PAR1 + PAR3 * (-DLOG(1.0 - CDFMIN))**(1.0/PAR2)
      DELX = (XMAX - XMIN)/(N - 1)
      DO 10 I = 1,N
   10 X(I) = XMIN + (I - 1) * DELX
   20 DO 30 I = 1,N
        CDF(I) = 1.0 - EXP( - ((X(I)-PAR1)/PAR3)**PAR2)
        PDF(I)=(PAR2/PAR3)*((X(I)-PAR1)/PAR3)**(PAR2-1.0)*EXP(-((X(I)-
     1           PAR1)/PAR3)**PAR2)
   30 CONTINUE
      RETURN
      END
C
      SUBROUTINE DISLP (N,X,PAR1,PAR3,PAR2,XIN,PDF,CDF,IX)
C     ******************************************************************
C     PROBABILITY DENSITY FUNCTION AND CDF OF THE LOG-PEARSON TYPE III
C                  DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  APRIL 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N), PDF(N), CDF(N), CK(2)
      DATA CK/0.4342944819,1.0/
      IF (IX.EQ.0) GOTO 150
  120 DO 130 I = 1,N
  130 X(I) = DLOG(X(I))
  140 YIN = X(N)
      IF (PAR3.LT.0) YIN = X(1)
      CALL DISGAM (N,X,PAR1,PAR3,PAR2,YIN,PDF,CDF,1)
      GOTO 160
  150 YIN = DLOG(XIN)
      CALL DISGAM (N,X,PAR1,PAR3,PAR2,YIN,PDF,CDF,0)
  160 DO 180 I = 1,N
         X(I) = EXP(X(I))
  180 PDF(I) = CK(2) * PDF(I)/X(I)
      RETURN
      END
C
      SUBROUTINE QUANOR (PAR1,PAR3,N,CDF,X,ICDF)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE NORMAL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : MARCH 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  CDF(N), X(N)
      IF (ICDF.GT.0) GOTO 110
      AN1 = FLOAT(N + 1)
      DO 100 I = 1,N
  100 CDF(I) = FLOAT(I)/AN1
  110 DO 120 I = 1,N
         X(I) = XNORM(CDF(I))
  120 X(I) = PAR1 + X(I) * PAR3
      RETURN
      END
C
      SUBROUTINE QUAGAM (PAR1,PAR3,PAR2,N,CDF,X,ICDF,ipar)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE GAMMA DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM , UNIVERSITY OF SEOUL
C
C     DATE ORIGINAL VERSION :  MARCH 1987     REVISION : APRIL 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), CDF(N)
	IF (ICDF.EQ.0) THEN
	   DO 100 I=1,N
	      CDF(I) = DFLOAT(I)/DFLOAT(N+1)
  100	   CONTINUE	
	ENDIF
C      
	IF (IPAR.EQ.2) THEN
	P1=PAR3
	P2=PAR2
	DO 200 I=1,N
	   X(I) = FQUAGAM(CDF(I),P2,P1)
  200 CONTINUE
      ENDIF
C
	IF (IPAR.EQ.3) THEN
	P1=PAR1+2.0D0*PAR3
	P2=PAR3*DSQRT(DABS(PAR2))
	P3=2.0D0/DSQRT(DABS(PAR2))
C
	DO 300 I=1,N
	   X(I) = QUAPE3(CDF(I),P1,P2,P3)
  300	CONTINUE
      ENDIF

	RETURN
	END
C
C
      SUBROUTINE QUAGEV (PAR1,PAR3,PAR2,N,CDF,X,ICDF)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE GEV DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM , UNIVERSITY OF SEOUL
C
C     DATE ORIGINAL VERSION :  MARCH 1983     REVISION : MAY. 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), CDF(N)
      DATA TRESH/0.00001/
      IF (ABS(PAR2).LT.TRESH) GOTO 160
      ITYP = 2
      IF (ICDF.GT.0) GOTO 110
      DO 100 I = 1,N
  100 CDF(I) = FLOAT(I)/(N + 1)
  110 DO 120 I = 1,N
         IF (CDF(I).LE.0.0.OR.CDF(I).GE.1.0) GOTO 180
  120 X(I) = PAR1 + PAR3 * (1.0 - (-DLOG(CDF(I))) ** PAR2)/PAR2
      IF (PAR2.GT.0.) ITYP = 3
      RETURN
  160 WRITE(6,170) PAR2,TRESH
  170 FORMAT(/1X,6HPAR2 =,F13.6,2X,26HSINCE PAR2 IS SMALLER THAN,F9.6,1X
     1,12HIT IS BETTER,/1X,52HTO USE SUBROUTINE QUAGUM FOR THE GUMBEL DI
     2STRIBUTION,//)
      RETURN
  180 WRITE(6,190)
  190 FORMAT (//1X,59HPROGRAM STOPS BECAUSE AN INPUT CDF IS .LE. 0.0 O R
     1 .GE. 1.0,/)
      RETURN
      END
C
      SUBROUTINE QUAGUM (PAR1,PAR3,N,CDF,X,ICDF)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE GUMBEL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     DATE ORIGINAL VERSION :  MARCH 1983     REVISION : MAY 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), CDF(N)
      IF (ICDF.GT.0) GOTO 110
      DO 100 I = 1,N
  100 CDF(I) = FLOAT(I)/(N + 1)
  110 DO 120 I = 1,N
      X(I) = PAR1 - PAR3 * DLOG( - DLOG(CDF(I)))
  120 CONTINUE
      RETURN
      END
C
      SUBROUTINE QUALOG (PAR1,PAR3,PAR2,N,CDF,X,ICDF)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE GUMBEL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     DATE ORIGINAL VERSION :  APRIL, 1983     REVISION : MAY 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  CDF(N), X(N), CK(2)
      DATA CK/0.4342944819,1.0/
      IPAR = 3
      IF (ICDF.GT.0) GOTO 110
      DO 100 I = 1,N
  100 CDF(I) = DFLOAT(I)/(N + 1)
  110 DO 130 I = 1,N
         CCDF = CDF(I)
         IF (CCDF.GT.0.0) GOTO 120
         X(I) = PAR1
         GOTO 130
  120    X(I) = XNORM(CCDF)
         X(I) = PAR1 + DEXP((PAR3 + X(I) * PAR2)/CK(2))
  130 CONTINUE
      IF (PAR1.EQ.0.) IPAR = IPAR - 1
      RETURN
      END
C
      SUBROUTINE QUALP (PAR1,PAR3,PAR2,N,CDF,X,ICDF,XIN)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE LOG-PEARSON TYPE III DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     DATE ORIGINAL VERSION :  APRIL 1983     REVISION : MAY, 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N), CDF(N),PARA(3)


      CALL QUAGAM (PAR1,PAR3,PAR2,N,CDF,X,ICDF,3)
      DO 110 I = 1,N
         if(ABS(x(i)).gt.100.) then
C         write(6,339)
C  339    format(3x,'X OF QUAGAM IS VERY BIG')
         RETURN
         END IF
         X(I) = EXP(X(I))
  110 CONTINUE
      RETURN
      END
C
      SUBROUTINE QUAWBU (PAR1,PAR3,PAR2,IPAR,N,CDF,X,ICDF)
C     ******************************************************************
C     QUANTILE FUNCTION OF THE WEIBULL DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     DATE ORIGINAL VERSION : NOV. 1992       REVISION : MAY, 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), CDF(N)
      IF (IPAR.EQ.2) PAR1 = 0.0
      IF (ICDF.GT.0) GOTO 110
      DO 10 I = 1,N
   10 CDF(I) = FLOAT(I)/(N + 1)
  110 DO 20 I = 1,N
      X(I) = PAR1 + PAR3 * ( - DLOG(1.0 - CDF(I)))**(1/PAR2)
   20 CONTINUE
      RETURN
      END
C
      DOUBLE PRECISION FUNCTION ALNGAMX(Z)
C     ******************************************************************
C     LOGARITHM OF COMPLETE GAMMA FUNCTION IN Z
C     Z  = ARGUMENT IN FUNCTION. Z MUST BE GREATER OR EQUAL TO ZERO.
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : JULY, 1991
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION CF(6)
      DATA CF,PS/76.18009173D0,-86.50532033D0,24.01409822D0,-1.231739516
     1D0,0.120858003D-2,-0.536382D-5,2.50662827465D0/
      ALNGAMX = 0.0
      IF (Z.EQ.0.0) RETURN
      IF (Z.LT.0.0) GOTO 110
      U = Z - 1.0D0
      S = 1.0D0
      DO 100 I = 1,6
         U = U + 1.0D0
  100 S = S + CF(I)/U
      V = Z + 4.5D0
      ALNGAMX = DLOG(S * PS) - V + (Z - 0.5D0) * DLOG(V)
      RETURN
  110 WRITE(*,120) Z
      RETURN
  120 FORMAT (//1X, 33HJOB TERMINATED IN FUNCTION ALNGAM,/1X, 31HARGUMEN                                   .
     1T OF GAMMA FUNCTION Z = ,F12.4, 12H IS NEGATIVE,/)
      END
C
C=======================================================================
      SUBROUTINE MOMEN1 (N,X,EV,SD,CV,CS,IBIAS)
C     ******************************************************************
C     ESTIMATION OF SAMPLE MOMENTS OF A DATA
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : FEB. 1987
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N)
      AN = FLOAT(N)
      SX1 = 0.0D0
      SX2 = 0.0D0
      SX3 = 0.0D0
      DO 100 I = 1,N
         XI = X(I)
         SX1 = SX1 + XI
         SX2 = SX2 + XI * XI
         SX3 = SX3 + XI * XI * XI
  100 CONTINUE
      EV = SX1/AN
      SD = SQRT(SX2/AN - EV * EV)
      CV = SD/EV
      CS = (SX3/AN-3.0D0*EV*SX2/AN+2.0D0*EV*EV*EV)/(SD*
     1 SD * SD)
      IF (IBIAS.EQ.1) GOTO 110
      AN1 = AN - 1.0D0
      SD = SD * SQRT(AN/AN1)
      CV = SD/EV
      CS = CS * SQRT(AN * AN1)/(AN - 2.0D0)
  110 RETURN
      END
C=====================================================================
      SUBROUTINE SORT (N,X,IOR)
C     ******************************************************************
C     SORT THE SAMPLE SERIES EITHER IN INCREASING OR DECREASING ORDER
C     OF MAGNITUDE
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  JANUARY 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N)
      M = N - 1
      IF (IOR.GT.0) GOTO 120
      DO 110 J = 1,M
         K = J + 1
         DO 100 I = J,N
  100    IF (X(I).LT.X(K)) K = I
         A = X(J)
         X(J) = X(K)
  110 X(K) = A
      RETURN
  120 DO 140 J = 1,M
         K = J + 1
         DO 130 I = J,N
  130    IF (X(I).GT.X(K)) K = I
         A = X(J)
         X(J) = X(K)
  140 X(K) = A
      RETURN
      END
C
      DOUBLE PRECISION FUNCTION GAMFCT(Z)
C     ******************************************************************
C     COMPLETE GAMMA FUNCTION IN Z
C     Z  = ARGUMENT IN FUNCTION. Z MUST BE GRETER OR EQUAL TO ZERO.
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : MARCH 1987
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION CF(6)
      DATA CF,PS/76.18009173D0,-86.50532033D0,24.01409822D0,-1.231739516
     1D0,0.120858003D-2,-0.536382D-5,2.50662827465D0/
      GAMFCT = 1.0
      IF (Z.EQ.0.0) RETURN
      IF (Z.LT.0.0) GOTO 110
      U = Z - 1.0D0
      S = 1.0D0
      DO 100 I = 1,6
         U = U + 1.0D0
  100 S = S + CF(I)/U
      V = Z + 4.5D0
      GAMFCT = S * PS * DEXP( - V + (Z - 0.5D0) * DLOG(V))
      RETURN
  110 WRITE(*,120) Z
      RETURN
  120 FORMAT (//1X, 33HJOB TERMINATED IN FUNCTION GAMMA.,/1X, 31HARGUMEN
     1T OF GAMMA FUNCTION Z = ,F12.4, 12H IS NEGATIVE,/)
      END
C
C==== SUBROUTINE FOR PDF AND CDF CALCULATION
C
      DOUBLE PRECISION FUNCTION PDFGAM(X,PAR1,PAR3,PAR2)
C     ******************************************************************
C     THE PROBABILITY DENSITY FUNCTION OF THE GAMMA DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : MARCH, 1987
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      Z = (X - PAR1)/PAR3
      PDFGAM = 0.0
      IF (Z.LE.0.0) RETURN
      PDFGAM=DEXP(-Z + (PAR2-1.0) * DLOG(Z) - ALNGAMX(PAR2)) / ABS(PAR3)
      RETURN
      END
C
      DOUBLE PRECISION FUNCTION CDFGAM(X,PAR1,PAR3,PAR2,ICNV)
C     ******************************************************************
C     THE CUMULATIVE DISTRIBUTION FUNCTION OF THE GAMMA DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : MARCH 1987
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA ERROR,ITMAX/3.0E-05,100/
      ICNV = 0
      A = PAR2
      Z = (X - PAR1)/PAR3
      CDFGAM = 0.0
      IF (Z.LE.0.0) RETURN
      IF (Z.GE.(A + 1.0)) GOTO 120
C     SERIES REPRESENTATION
      A0 = A
      A1 = 1.0D0/A
      R0 = A1
      DO 100 I = 1,ITMAX
         A0 = A0 + 1.0D0
         R0 = R0 * Z/A0
         A1 = A1 + R0
         IF (DABS(R0).LT.(DABS(A1) * ERROR)) GOTO 110
  100 CONTINUE
      ICNV = 1
      RETURN
  110 CDFGAM = A1 * DEXP( - Z + A * DLOG(Z) - ALNGAMX(PAR2))
      IF (PAR3.LT.0.0) CDFGAM = 1.0 - CDFGAM
      RETURN
C     CONTINUED FRACTION REPRESENTATION
  120 SO = 0.0D0
      A0 = 1.0D0
      A1 = Z
      B0 = 0.0D0
      B1 = 1.0D0
      R0 = 1.0D0
      DO 130 I = 1,ITMAX
         AI = FLOAT(I)
         AIA = AI - A
         A0 = (A1 + A0 * AIA) * R0
         B0 = (B1 + B0 * AIA) * R0
         AIF = AI * R0
         A1 = Z * A0 + AIF * A1
         B1 = Z * B0 + AIF * B1
         IF (A1.EQ.0.0) GOTO 130
         R0 = 1.0D0/A1
         SN = B1 * R0
         IF (DABS((SN - SO)/SN).LT.ERROR) GOTO 140
         SO = SN
  130 CONTINUE
      ICNV = 1
      RETURN
  140 CDFGAM = 1.0 - SN * DEXP( - Z + A * DLOG(Z) - ALNGAMX(PAR2))
      IF (PAR3.LT.0.0) CDFGAM = 1.0 - CDFGAM
      RETURN
      END
C
      DOUBLE PRECISION FUNCTION XNORM(PROB)
C     *****************************************************************
C     POLYNOMIAL APPROXIMATION FOR THE ESTIMATION OF THE INVERSE OF THE
C     CDF OF THE NORMAL DISTRIBUTION(TAKEN FROM ABRAMOWITZ-STEGUN,1965)
C     *****************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PROM = PROB
      IF (PROB.GT.0.5) PROM = 1.0 - PROB
      V = SQRT( - 2. * DLOG(PROM))
      XNORM = V - (2.515517 + 0.802853 * V + 0.010328 * V ** 2.)/(1. +
     11.432788 * V + 0.189269 * V ** 2. + 0.001308 * V ** 3.)
      IF (PROB.LT.0.5) XNORM =  - XNORM
      RETURN
      END
C
      DOUBLE PRECISION FUNCTION DIGAM(Z)
C     ******************************************************************
C     ASYMPTOTIC EXPANSION OF DIGAMMA FUNCTION
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      Z1 = Z + 2.0
      Z2 = Z1 * Z1
      Z4 = Z2 * Z2
      Z6 = Z4 * Z2
C
      IF(Z1.LE.0.0000) THEN
      Z1=ABS(Z1)
      END IF
C
      A1 = DLOG(Z1) - 1.0/(2.0 * Z1) -1.0/(12.0 * Z2)
      A2 = 1.0/(120.0 * Z4) - 1.0/(252.0 * Z6)
      A3 = -1.0/(Z + 1.0) - 1.0/Z
      DIGAM = A1 + A2 + A3
      RETURN
      END
C
      SUBROUTINE CTABLE (NDF,BETA,CVALUE)
C     ******************************************************************
C     QUANTILE OF CHI-SQUARE DISTRIBUTION FUNCTION (CHI-SQUARE TABLE)
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  JAN. 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  C(37), C1(3,37), C2(3,37), U(3)
      DATA (U(I),I=1,3)/1.282,1.645,1.960/
      DATA ((C1(J,K),K=1,37),J=1,3)/0.0158,0.211,0.584,1.064,1.61,2.20,2
     1.83,3.49,4.17,4.87,5.58,6.3,7.04,7.79,8.55,9.31,10.09,10.86,11.65,
     212.44,13.24,14.04,14.85,15.66,16.47,17.29,18.11,18.94,19.77,20.60,
     329.1,37.7,46.5,55.3,64.3,73.3,82.4,0.023,0.103,0.352,0.711,1.145,1
     4.635,2.17,2.73,3.33,3.94,4.57,5.23,5.89,6.57,7.26,7.96,8.67,9.39,1
     50.12,10.85,11.59,12.34,13.09,13.85,14.61,15.38,16.51,16.93,17.71,1
     68.49,26.5,34.8,43.2,51.7,60.4,69.1,77.9,.03982,.0506,0.216,0.484,0
     7.831,1.237,1.69,2.18,2.7,3.25,3.82,4.4,5.01,5.63,6.26,6.91,7.56,8.
     823,8.91,9.59,10.28,10.98,11.69,12.4,13.12,13.84,14.57,15.31,16.05,
     916.79,24.50,32.5,40.5,48.8,57.2,65.6,74.2/
      DATA ((C2(J,K),K=1,37),J=1,3)/2.71,4.61,6.25,7.78,9.24,10.64,12.02
     1,13.36,14.68,15.99,17.28,18.55,19.81,21.1,22.3,23.5,24.8,26.,27.2,
     228.4,29.6,30.8,32.,33.2,34.4,35.6,36.7,37.9,39.1,40.3,51.8,63.2,74
     3.4,85.5,96.6,107.6,118.5,3.84,5.99,7.81,9.49,11.07,12.59,14.07,15.
     451,16.92,18.31,19.68,21.,22.4,23.7,25.,26.3,27.6,28.9,30.1,31.4,32
     5.7,33.9,35.2,36.4,37.7,38.9,40.1,41.3,42.6,43.8,55.8,67.5,79.1,90.
     65,101.9,113.1,124.3,5.02,7.38,9.35,11.14,12.83,14.45,16.01,17.53,1
     79.02,20.5,21.9,23.3,24.7,26.1,27.5,28.8,30.2,31.5,32.9,34.2,35.5,3
     86.8,38.1,39.4,40.6,41.9,43.2,44.5,45.7,47.,59.3,71.4,83.3,95.,106.
     96,118.1,129.6/
      IF (BETA.GT.0.09.OR.BETA.LT.0.91) I = 1
      IF (BETA.LT.0.09.AND.BETA.GT.0.04) I = 2
      IF (BETA.GT.0.91.AND.BETA.LT.0.96) I = 2
      IF (BETA.LT.0.04.OR.BETA.GT.0.96) I = 3
      IF (BETA.LT.0.20) GOTO 110
      DO 100 M = 1,37
  100 C(M) = C2(I,M)
      GOTO 130
  110 DO 120 M = 1,37
  120 C(M) = C1(I,M)
  130 IF (NDF - 30) 140,140,150
  140 CVALUE = C(NDF)
      GOTO 210
  150 IF (NDF - 100) 160,160,200
  160 DO 180 K = 1,7
         L = 30 + K * 10
         IF (NDF - L) 170,170,180
  170    J = 30 + K
         DELC = (NDF - (L - 10)) * (C(J) - C(J - 1))/10.
         GOTO 190
  180 CONTINUE
  190 CVALUE = C(J - 1) + DELC
      GOTO 210
  200 P = 1.0
      IF (BETA.LT.0.50) P =  - 1.0
      CVALUE = 0.5 * (P * U(I) + SQRT(2. * NDF - 1.)) ** 2
  210 RETURN
      END
C
      SUBROUTINE KSTABLE(N,BETA,TABKS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION TABLE(4,40)

      DATA ((TABLE(I,J),I=1,4),J=1,40)/0.9,     0.95,    0.975,   0.995,
     &                                 0.684,   0.776,   0.842,   0.929,
     &                                 0.565,   0.636,   0.708,   0.829,
     &                                 0.492,   0.565,   0.624,   0.734,
     &                                 0.447,   0.509,   0.563,   0.669,
     &                                 0.41,    0.468,   0.519,   0.617,
     &                                 0.381,   0.436,   0.483,   0.576,
     &                                 0.358,   0.41,    0.454,   0.542,
     &                                 0.339,   0.387,   0.43,    0.513,
     &                                 0.323,   0.369,   0.409,   0.489,
     &                                 0.308,   0.352,   0.391,   0.468,
     &                                 0.296,   0.338,   0.375,   0.449,
     &                                 0.285,   0.325,   0.361,   0.432,
     &                                 0.275,   0.314,   0.349,   0.418,
     &                                 0.266,   0.304,   0.338,   0.404,
     &                                 0.258,   0.295,   0.327,   0.392,
     &                                 0.25,    0.286,   0.318,   0.381,
     &                                 0.244,   0.279,   0.309,   0.371,
     &                                 0.237,   0.271,   0.301,   0.361,
     &                                 0.232,   0.265,   0.294,   0.352,
     &                                 0.226,   0.259,   0.287,   0.344,
     &                                 0.221,   0.252,   0.281,   0.337,
     &                                 0.216,   0.247,   0.275,   0.33,
     &                                 0.212,   0.242,   0.269,   0.323,
     &                                 0.208,   0.238,   0.264,   0.317,
     &                                 0.204,   0.233,   0.259,   0.311,
     &                                 0.2,     0.229,   0.254,   0.305,
     &                                 0.197,   0.225,   0.25,    0.3,
     &                                 0.193,   0.221,   0.246,   0.295,
     &                                 0.19,    0.218,   0.242,   0.29,
     &                                 0.187,   0.214,   0.238,   0.285,
     &                                 0.184,   0.211,   0.234,   0.281,
     &                                 0.182,   0.208,   0.231,   0.277,
     &                                 0.179,   0.205,   0.227,   0.273,
     &                                 0.177,   0.202,   0.224,   0.269,
     &                                 0.174,   0.199,   0.221,   0.265,
     &                                 0.172,   0.196,   0.218,   0.222,
     &                                 0.17,    0.194,   0.215,   0.258,
     &                                 0.168,   0.191,   0.213,   0.255,
     &                                 0.165,   0.189,   0.21,   0.252/
C
10    AL = BETA
      IF (AL.LT.0.801 .AND. AL.GT.0.799) THEN
        NAL=1
        AB=0.00256
      ELSEIF (AL.LT.0.901 .AND. AL.GT.0.899) THEN
        NAL=2
        AB=0.05256
      ELSEIF (AL.LT.0.951 .AND. AL.GT.0.949) THEN
        NAL=3
        AB=0.11282
      ELSEIF (AL.LT.0.991 .AND. AL.GT.0.989) THEN
        NAL=4
        AB=0.28464
      ELSE
        WRITE(*,11)
11      FORMAT(  '   SIGNIFICANCE LEVEL ERROR',
     &           '   GIVE THE NEW VALUE(0.8 OR 0.9 OR 0.95 OR 0.99)')
        READ(*,*)BETA
        GOTO 10
      ENDIF

      IF (N .LE. 40) THEN
        TKS_TAB=TABLE(NAL,N)
      ENDIF

      AL1=AL + (1.-AL)/2.
      IF (N .GT. 40) THEN
        TKS_TAB=DSQRT(DLOG(1/(1-AL1))/2/FLOAT(N)) -
     &  0.16693/FLOAT(N)-AB*(FLOAT(N))**(-1.5)
      ENDIF
      TABKS = TKS_TAB
      RETURN
      END
C
      SUBROUTINE CHITST(N,Y,NCL,NPAR,CLASS,CDF,ALPHA,CHICOM,CHITAB,JUDG)
C     ******************************************************************
C     CHI-SQUARE GOODNESS OF FIT TEST
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  JULY 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C      PARAMETER(IDATA=300)
      DOUBLE PRECISION  Y(N),CDF(N),CLASS(NCL),EB(N)
      DIMENSION NOB(N)
	CALL SORT (N,Y,0)
      LL = 0
      NSUM = 0
      DO 120 J = 1, NCL
         K = LL + 1
         L = 0
         DO 100 I = K,N
            IF (Y(I).GT.CLASS(J)) EXIT
            LL = LL + 1
            L  = L  + 1
  100    CONTINUE
         NOB(J) = L
C	WRITE(6,*)J,NOB(J),CLASS(J)
         NSUM = NSUM + NOB(J)
  120 CONTINUE
C
      NCL1 = NCL + 1
      NOB(NCL1) = N - NSUM
C	WRITE(6,*)NCL1,NOB(NCL1)
      EB(1) = DFLOAT(N) * CDF(1)
C	WRITE(*,*)EB(1),DFLOAT(N),CDF(1)
      DO 130 I = 2,NCL
      EB(I) = DFLOAT(N) * (CDF(I) - CDF(I - 1))
C	WRITE(*,*)EB(I),DFLOAT(N),CDF(I)
  130 CONTINUE
      EB(NCL1) = DFLOAT(N) * (1.0D0 - CDF(NCL))
C	WRITE(*,*)EB(NCL1),DFLOAT(N),1.-CDF(NCL)
      CHICOM = 0.0D0
      IZERO = 0
      DO 150 I = 1,NCL1
        CHICOM = CHICOM+(DFLOAT(NOB(I)) - EB(I))
     1           *(DFLOAT(NOB(I)) - EB(I))/EB(I)
C	WRITE(*,*) CHICOM,DFLOAT(NOB(I)),EB(I)
C	PAUSE
  150 CONTINUE
      NDF  = NCL - NPAR
      BETA = 1.0 - ALPHA
          CALL CTABLE (NDF,BETA,CHITAB)
          IF (NDF .LT. 1.5) CHITAB=3.84D0
          IF (NDF .EQ. 1) THEN
             CALL CTABLE1(NDF,BETA,CHITAB)
          ENDIF
      JUDG = 0
      IF (CHICOM.GT.CHITAB) GOTO 160
      JUDG = 1
  160 RETURN
      END
C
      SUBROUTINE CTABLE1(N,AL,CHIS)
C     ******************************************************************
C     QUANTILE OF CHI-SQUARE DISTRIBUTION FUNCTION (CHI-SQUARE TABLE)
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      XTERM=0.01D0
      CHIS=0.0
      IF (N.LT.4 .AND. AL.LT. 0.11) XTERM=XTERM*0.1D0
      NU=N
      GNU=NU/2.
      CALL GMMMA (GNU,GAMMA,IER)

      X1=0.0D0
      X2=XTERM
      SSUM=0.0D0

      DO J=1,100000
      CALL ROMBERG(NU,GAMMA,SUM,X1,X2)
      SSUM=SSUM+SUM
      AL2=ABS(SSUM-AL)
      IF (SSUM.GT.AL) EXIT
      AL1=ABS(SSUM-AL)
      X1=X2
      X2=X2+XTERM
      ENDDO
C
      CHIS=X2
      IF (AL2. GT. AL1) CHIS=X1
C
      RETURN
      END
C
C
      SUBROUTINE GMMMA (XX,GX,IER)
      IMPLICIT REAL*8 (A-H,O-Z)

      IF (XX-57.) 2,2,1
    1 GX=0.39909-0.43429*(XX-1.0)+(XX-0.5)*DLOG10(XX-1.0)
      GX=10.0**GX
      RETURN
    2 X=XX
       ERR=1.0E-6
      IER=0
      GX=1.0
      IF (X-2.0) 5,5,4
    3 IF (X-2.0) 11,11,4
    4 X=X-1.0
      GX=GX*X
      GOTO 3
    5 IF (X-1.0) 6,12,11
    6 IF (X-ERR) 7,7,10
    7 Y=DBLE(INT(X))-X
      IF (DABS(Y)-ERR) 13,13,8
    8 IF (1.0-Y-ERR) 13,13,9
    9 IF (X-1.0) 10,10,11
   10 GX=GX/X
      X=X+1.0
       GOTO 9
   11 Y=X-1.0
      GY=1.+Y*(-0.5771017+Y*(+0.9858540+Y*(-0.8764218+Y*(+0.8328212+Y*(
     1-0.5684729+Y*(+0.2548205+Y*(-0.05149930)))))))
       GX=GX*GY
   12 RETURN
   13 IER=1
      RETURN
      END
C
      SUBROUTINE ROMBERG(M1,GAMMA,SUM,X1,X2)
      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION R(20,20)

      MR=4
      H1=(X2-X1)
      IF (M1 .EQ. 1  .AND. X1 .EQ. 0.0D0) THEN
        X1=X2/285.
      ENDIF
      R(1,1)=H1/2.0D0*(FCHI(X1,M1,GAMMA)+FCHI(X2,M1,GAMMA))

      DO K=2,MR
          H2=H1/2.0D0
               CHA=0.0D0
               DO I=1,2**(K-2)
                 CHA=CHA+FCHI(X1+(2*I-1)*H2,M1,GAMMA)
               ENDDO
           R(K,1)=1.0D0/2.0D0*(R(K-1,1)+H1*CHA)
          H1=H1/2.0D0
          DO J=2,K
             R(K,J)=R(K,J-1)+(R(K,J-1)-R(K-1,J-1))/(4.0D0**(J-1)-1)
             SUM=R(K,J)
          ENDDO
      ENDDO

      RETURN
      END
C
C CHI FUNCTION FUNCTION FUNCTION FUNCTION FUNCTION FUNCTION FUNCTION

      DOUBLE PRECISION FUNCTION FCHI(X,NU,GAMMA)
      IMPLICIT REAL*8(A-H,O-Z)

      IF (X .EQ. 0 .AND. NU .EQ. 2 )THEN
      A1 = 0.0D0
      ELSE
      A1=X**(-(1.-NU/2.))
      ENDIF
      A2=EXP(-X/2.)
      FCHI=A1*A2/(2**(NU/2.) * GAMMA)

      RETURN
      END
C
      SUBROUTINE KSTST (N,CDF,IPP,ECDF,ALPHA,KSCOM,KSTAB,JUDG)
C     ******************************************************************
C     KOLMOGOROV-SMIRNOV GOODNESS OF FIT TEST
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  JULY 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  CDF(N), ECDF(N)
	REAL*8 KSTAB,KSCOM
      KSCOM = 0.0
      DO 100 I = 1,N
         IF (IPP.LT.2) ECDF(I) = FLOAT(I)/(N + IPP)
         DIF = ABS(ECDF(I) - CDF(I))
  100 IF (DIF.GT.KSCOM) KSCOM = DIF
      IF (N.LT.5) GOTO 120
      BETA = 1.0 - ALPHA
      CALL KSTABLE (N,BETA,KSTAB)
      JUDG = 0
      IF (KSCOM.GT.KSTAB) GOTO 110
      JUDG = 1
  110 RETURN
  120 WRITE(6,170)
  170 FORMAT (/1X,'THERE IS NO TABULATED TEST VALUE FOR THE GIVEN SAMPLE
     1 SIZE (N LESS THAN 5)')
      RETURN
      END
C
      SUBROUTINE PARGAM (N,X,PAR1,PAR3,PAR2,IPAR,IBIAS,XMIN,XMAX,
     1                    KVALID)
C     ******************************************************************
C     PARAMETER ESTIMATION VIA METHOD OF MOMENT FOR THE GAMMA DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : APRIL 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N)
      CHARACTER*9 EST(2)
      DATA EST/'(BIASED  ','(UNBIASED'/

C     MOMENT ESTIMATES OF THE 2 PARAMETER GAMMA DISTRIBUTION

C
      CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
      VN = N
C
      CALL MOMEN1 (N,X,EV,SD,CV,CS,IBIAS)
C
      IF (IPAR.EQ.3) GOTO 130
      PAR2 = (EV/SD) ** 2.
      PAR3 = EV/PAR2
      RETURN
C     MOMENT ESTIMATES OF THE 3 PARAMETER GAMMA DISTRIBUTION
  130 IF (IBIAS.EQ.2) CS = CS * (1. + 8.5/VN)
        IF(CS.EQ.0.) THEN
           WRITE(6,131) CS
           CS=CS+0.00000001
  131 FORMAT(F5.3)
        ELSE
        ENDIF
      PAR2 = 4./(CS ** 2.)
      PAR3 = CS * SD/2.
      PAR1 = EV - (2. * SD/CS)
C
      CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
C
        IF(PAR3.GE.0.000) THEN
        KVALID = 1
            IF(PAR1.LE.XMIN) THEN
                 KVALID = 1
            ELSE
                 KVALID = 2
            END IF
        ELSE  IF(PAR3.LT.0.000) THEN
        KVALID = 1
                   IF(PAR1.GE.XMAX) THEN
                        KVALID = 1
                   ELSE
                        KVALID = 2
                   END IF
        END IF
      RETURN
      END
C
      SUBROUTINE PARGEV(N,X,PAR1,PAR3,PAR2,IBIAS,ITYP,xmax,xmin,kvalid,
     1                    cs)
C     ******************************************************************
C     PARAMETER ESTIMATION VIA METHOD OF MOMENT FOR THE GEV DISTRIBUTION
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  MARCH 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N)
      CHARACTER*8 EST(2)
      DATA TRESH/0.00001D0/
      DATA EST/'BIASED  ','UNBIASED'/

C     MEAN, STAND.DEV. AND SKEWNESS OF THE ORIGINAL DATA

      CALL MOMEN1 (N,X,XM,SX,CV,CS,IBIAS)
      IF (CS.LE.8.0D0.AND.CS.GE. -3.8D0) GOTO 110
      kvalid = 3
      RETURN
  110 IF (CS.LT.0.10D0.AND.CS.GE. - 3.8D0) GOTO 120

C     SHAPE PARAMETER AND THE STATISTICS OF THE REDUCED VARIATE
      PAR2 = 0.2792377D0-0.339836D0*CS+0.1008508D0*CS**2-0.0165458D0*
     1 CS**3+.0014037D0*CS**4-.0000479D0*CS**5
      GOTO 130
  120 PAR2 =0.277439D0-0.322359D0*CS+0.065677D0*CS**2+.029405D0*CS
     1     **3+.003176D0*CS**4
  130 ZA = 1.0D0 + PAR2
      GA = GAMFCT(ZA)
      ZB = 1.0D0 + 2.0D0 * PAR2
      GB = GAMFCT(ZB)
      GIMSI=GB - GA ** 2
C
      IF (GIMSI.LE.0.0000D0) THEN
         WRITE(6,179) GIMSI
c        GIMSI=ABS(GIMSI)
         kvalid = 2
         return
      END IF
C
      B = SX/SQRT(GIMSI)
      ITYP = 2
      IF (ABS(PAR2).LE.TRESH) ITYP = 1
      IF (PAR2.GT.TRESH) ITYP = 3
      GOTO (140,150,150), ITYP
  140 PAR3 = 0.77970D0 * SX
      PAR1 = XM - 0.57721570D0 * PAR3
      GOTO 160
  150 ISIGN = ( - 1.00D0) ** ITYP
      PAR3 =  - (B * PAR2) * ISIGN
      A = XM - (B * GA) * ISIGN
      PAR1 = A + B * ISIGN
C
      CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
c
      kvalid = 1
      if (ityp.eq.1) kvalid = 1
         if (ityp.eq.2) then
            kvalid = 1
            d = PAR1 + PAR3/PAR2
            if (d.gt.xmin) kvalid = 2
               kvalid = 1
         else
            kvalid = 1
            d = PAR1 + PAR3/PAR2
            if (d.lt.xmax) kvalid = 2
               kvalid = 1
         end if
  160 RETURN
  179 FORMAT(2X,'======= GB - GA ** 2 IS NEGATIVE =======',5X,
     1'GB - GA ** 2 = ',F12.3)
      END
C
      SUBROUTINE PARGUM (N,X,PAR1,PAR3,IBIAS,xmax,xmin,kvalid)
C     ******************************************************************
C     PARAMETER ESTIMATION VIA METHOD OF MOMENT FOR THE GUMBEL DIS.
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  MARCH 1983     REVISION : FEB. 1994
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N)
      CHARACTER*9 EST(2)
      DATA EST/'(BIASED  ','(UNBIASED'/
      CALL MOMEN1 (N,X,XM,SX,CV,CS,IBIAS)
      PAR3 = 0.7797 * SX
      PAR1 = XM - 0.45 * SX
C
      CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
      kvalid = 1
      RETURN
      END
C
      SUBROUTINE PARLOGN(N,X,PAR1,PAR3,PAR2,IPAR,xmin,xmax,kvalid,IBIAS)
C     ******************************************************************
C     PARAMETER ESTIMATION VIA METHOD OF MOMENT FOR THE LOGNORMAL DIS.
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : APRIL 1983
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N), CK(2)   !!!!!!!!!!!!!!! JO(10000)   20000222
      CHARACTER*9 EST(2), LABEL2(2)
      DATA EST/'(BIASED  ','(UNBIASED'/
      DATA LABEL2/'(BASE-10)','(BASE-E )'/
      DATA CK/0.4342944819,1.0/
C
C      IC = IC + 1      !!!!!!!!!
C
      CALL SORT(N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
C
      CALL MOMEN1 (N,X,EMX,SD,CV,CS,IBIAS)
      IF (IPAR.EQ.2) THEN
        IF (X(1).LE.0.0) THEN
          WRITE(6,150)
  150 FORMAT (4X,'NOTE : XLO SHOULD BE SMALLER THAN MINIMUM OF X')
        RETURN
        END IF
         PAR3 = 0.5 * DLOG(EMX**2/(1.0 + CV**2))
         PAR2 = SQRT(DLOG(1.0 + CV**2))
         PAR3 = PAR3 * CK(2)
         PAR2 = PAR2 * CK(2)
      ELSE IF (IPAR.EQ.3) THEN
        IF (CV.LE.0.0) THEN
          WRITE(6,130) CV
  130 FORMAT (/,1X,'NO CONVERGENCE !  PLEASE CHANGE ITMAX OR ERROR')
          goto 703
        END IF
        S1 = (1.0 + CS * (CS + (4.0 + CS**2)**0.5)/2.0)**(1.0/3.0)
        S2 = (1.0 + CS * (CS - (4.0 + CS**2)**0.5)/2.0)**(1.0/3.0)
        W = S1 + S2 -1.0
        IF(W.EQ.1.0) THEN
           W = W + 0.0000001
           JO = 1       !!!!!!!!!
         ELSE
           JO = 0       !!!!!!!!!
        ENDIF
        PAR2 = SQRT(DLOG(W))
        PAR3 = 0.5 * DLOG(SD**2/(W*(W - 1.0)))
        PAR2 = PAR2 * CK(2)
        PAR3 = PAR3 * CK(2)
        PAR1 = EMX - EXP(PAR3/CK(2) + (PAR2/CK(2))**2/2.0)
        IF (X(1).LE.PAR1) THEN
          WRITE(6,140) X(1),PAR1
  140 FORMAT (4X,'NOTE : XLO SHOULD BE SMALLER THAN XSC')
          goto 703
        END IF
      END IF
C
 703  CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
c
c       IF(PAR3.GE.0.000) THEN
        KVALID = 1
            IF(PAR1.LE.DLOG(XMIN)) THEN
                 KVALID = 1
            ELSE
                 KVALID = 2
            END IF
      return
      END
C
C
      SUBROUTINE PARLP3 (N,X,PAR1,PAR3,PAR2,GCS,xmax,xmin,kvalid,
     1                   IBIAS)
C     ******************************************************************
C     PARAMETER ESTIMATION VIA METHOD OF MOMENT FOR THE LP3 DIS.
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION :  APRIL 1983     REVISION : FEB. 1994
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N), CK(2)
C
      CALL SORT(N,X,0)
      XMIN = X(1)
      XMAX = X(N)
C
      XM1 = 0.0D0
      XM2 = 0.0D0
      XM3 = 0.0D0
      DO 100 I = 1,N
         XM1 = XM1 + X(I)/DFLOAT(N)
         XM2 = XM2 + X(I)**2./DFLOAT(N)
  100 XM3 = XM3 + X(I)**3./DFLOAT(N)
C      
	B = (DLOG(XM3)-3.0D0*DLOG(XM1))/(DLOG(XM2)-2.0D0*DLOG(XM1))
	C = 1.0D0/(B-3.0D0)
	IF (B.GT.3.5D0 .AND. B .LE.6.0D0) THEN
	  A=-0.23019D0 + 1.65262D0*C + 0.20911D0*C**2. - 0.04557D0*C**3.
	ENDIF
	IF(B.GT.3.0D0 .AND. B.LE.3.5D0) THEN
	  A= -0.457157D0 + 1.99955D0*C
	ENDIF
	IF(B.LT.3.0D0.OR.B.GT.6.0D0) KVALID = 2
	PAR3 = 1.0D0/(A+3.0D0)
	PAR2 = (DLOG(XM2)-2.0D0*DLOG(XM1))/(DLOG((1.0D0-PAR3)**2)
	1      -DLOG(1.0D0-2.0D0*PAR3))
	PAR1 = DLOG(XM1) + PAR2*DLOG(1.0D0-PAR3)
C
        IF(PAR3.GE.0.000) THEN
        KVALID = 1
            IF(PAR1.LE.DLOG(XMIN)) THEN
                 KVALID = 1
            ELSE
                 KVALID = 2
            END IF
        ELSE  IF(PAR3.LT.0.000) THEN
        KVALID = 1
            IF(PAR1.GE.DLOG(XMAX)) THEN
                 KVALID = 1
            ELSE
                 KVALID = 2
            END IF
        END IF
C
      RETURN
	END
C
      SUBROUTINE PARWBU(N,X,PAR1,PAR3,PAR2,IPAR,IBIAS,xmax,xmin,kvalid,
     1                    cs)
C     ******************************************************************
C     PARAMETER ESTIMATION VIA METHOD OF MOMENT FOR THE WEIBULL DIS.
C
C     DEVELOPED BY YOUNG-IL MOON AND YOUNG-IL CHA
C     WATER RESOURCES LAB. PROGRAM,
C     UNIVERSITY OF SEOUL, KOREA
C
C     REVISION : MAY, 2001
C     DATE ORIGINAL VERSION : NOV. 1992
C     ******************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION  X(N)
      CHARACTER*8 EST(2)
      DATA EST/'  BIASED','UNBIASED'/
      DATA ITMAX,ERROR/500,1.0E-4/
C     MEAN, STAND.DEV. AND SKEWNESS OF THE ORIGINAL DATA
C
      CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
c
C
      CALL MOMEN1 (N,X,XM,SD,CV,CS,IBIAS)
      IF (CS.GT.0.35d0.AND.CS.LE.6.6d0) THEN
      PAR2 = 3.156997d0-2.282672d0* CS+0.8403815d0*CS**2 -0.1396762d0
     1   *CS**3+0.0084155d0 * CS**4
      ENDIF
      IF (CS.GT.-0.98D0.AND.CS.LE.0.35D0) THEN
        PAR2=3.566987d0-4.703961d0*CS+6.586978d0*CS**2 +13.3137d0*
     1      CS**3-13.86354d0* CS**4-133.5880d0*CS**5 -
     2      49.61454d0*CS**6+212.2529d0* CS**7+180.3612d0*CS**8
      ENDIF
      IF (CS.GT.6.6d0.OR.CS.LE.-0.98d0) THEN
c       WRITE(6,120) CS
        kvalid = 3
        RETURN
      ENDIF
      ITER = 0
 111  Z1 = 1.0d0 + 1.0d0/PAR2
      Z2 = 1.0d0 + 2.0d0/PAR2
      Z3 = 1.0d0 + 3.0d0/PAR2
            IF(Z1.LT.0.0D0.OR.Z2.LT.0.0D0.OR.Z3.LT.0.0D0)THEN    !!!!!!!!!
                 KVALID = 2
                 return
            END IF
      G1 = GAMFCT(Z1)
      G2 = GAMFCT(Z2)
      G3 = GAMFCT(Z3)
      FG1 = G1 * DIGAM(Z1)
      FG2 = G2 * DIGAM(Z2)
      FG3 = G3 * DIGAM(Z3)
      ITER = ITER + 1
      IF (IPAR.EQ.2) THEN
        FCT = G2/G1**2 - 1.0d0 - (SD/XM)**2
        DFCT = 2.0d0* G2 * (DIGAM(Z1) - DIGAM(Z2))/
     1         (PAR2 * G1)**2
      ELSE IF (IPAR.EQ.3) THEN
C      WRITE(*,*)'G1',G1         !!!!!!!!!!!!!!!!!!!!!!
        FCT = (G3-3.0D0*G2*G1+2.0D0*G1**3)/(G2-G1**2)**(1.5)-CS
        DFCT =((-3.0D0*FG3+ 3.0D0*FG1*G2+6.0D0*G1*FG2-6.0D0*
     1     FG1 * G1**2) * (G2-G1**2) - (G3-3.0D0*G1*G2+2.0D0*
     2     G1**3)*(-3.0D0*FG2+3.0D0*FG1*G1))/(PAR2**2*(G2-
     3     G1**2)**(2.5))
C      WRITE(*,*)'G2',G1          !!!!!!!!!!!!!!!!!!!!!!!
      END IF
      if (dabs(dfct).lt.0.00000000001d0) then   !!!!!!!!!!!!!!!!!!!
        kvalid=2
c        write(*,*)kvalid
        return
      endif
      PAR2NEW = PAR2 - FCT/DFCT
      DIF = ABS((PAR2NEW - PAR2)/PAR2NEW)
      IF (DIF.GT.ERROR) THEN
        PAR2 = PAR2NEW
          IF (ITER.GT.ITMAX) THEN
C            WRITE(6,130)
            kvalid = 2
            RETURN
          END IF
        GOTO 111
      END IF
      PAR2 = PAR2NEW
      Z1 = 1.0d0 + 1.0d0/PAR2
      Z2 = 1.0d0 + 2.0d0/PAR2
            IF(Z1.LT.0.0D0.OR.Z2.LT.0.0D0)THEN    !!!!!!!!!!!!!!!!!!!!!!!!!!
                 KVALID = 2
                 return
            END IF
      IF (IPAR.EQ.2) THEN
        PAR3 = XM/GAMFCT(Z1)
        PAR1 = 0.0d0
      ELSE IF (IPAR.EQ.3) THEN
        PAR3 = SD/(GAMFCT(Z2) - GAMFCT(Z1)**2)**0.5
        PAR1 = XM - PAR3 * GAMFCT(Z1)
      END IF
      IF(KVALID.EQ.3) RETURN
C
      CALL SORT (N,X,0)
C
      XMIN=X(1)
      XMAX=X(N)
c
      kvalid = 1
            IF(PAR1.LE.XMIN) THEN
                 KVALID = 1
            ELSE
                 KVALID = 2
            END IF
C
      RETURN
      END
C
C===================================================== QUAGAM.FOR
      DOUBLE PRECISION FUNCTION FQUAGAM(F,PAR1,PAR2)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  QUANTILE FUNCTION OF THE GAMMA DISTRIBUTION
C
C  OTHER ROUTINES USED: DERF,DLGAMA,GAMIND,QUASTN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(2)
      DATA ZERO/0D0/,P01/0.01D0/,ONE/1D0/,NINE/9D0/
C
C         EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF N-R ITERATION
C
      DATA EPS/1D-10/,MAXIT/30/
C
	PARA(1)=PAR1
	PARA(2)=PAR2
      FQUAGAM=ZERO
      ALPHA=PARA(1)
      BETA=PARA(2)
      IF(ALPHA.LE.ZERO.OR.BETA.LE.ZERO)GOTO 1000
      IF(F.LT.ZERO.OR.F.GE.ONE)GOTO 1010
      IF(F.EQ.ZERO)RETURN
      AM1=ALPHA-ONE
      IF(AM1.NE.ZERO)GOTO 10
C
C         CASE ALPHA.EQ.1 - GAMMA IS EXPONENTIAL
C
      FQUAGAM=(-DLOG(ONE-F))*BETA
      RETURN
C
C         INITIAL ESTIMATE OF ROOT OF EQUATION GAMIND(X)=F:
C         - IF ALPHA.GT.1, USE WILSON-HILFERTY APPROXIMATION IF IT'S
C           POSITIVE AND NOT TOO CLOSE TO ZERO;
C         - IF ALPHA.LT.1, OR IF W-H APPROX. ISN'T POSITIVE ENOUGH,
C           USE THE SMALL-X APPROXIMATION OF IGNORING THE EXP(-T) TERM
C           IN THE INTEGRAL DEFINING GAMIND(X)
C
   10 DLOGG=DLGAMA(ALPHA)
      IF(AM1.LE.ZERO)GOTO 20
      ROOT=ALPHA*(ONE-ONE/(NINE*ALPHA)+QUASTN(F)/DSQRT(NINE*ALPHA))**3
      IF(ROOT.GT.P01*ALPHA)GOTO 30
   20 ROOT=DEXP((DLOG(ALPHA*F)+DLOGG)/ALPHA)
   30 CONTINUE
C
C         REFINE INITIAL ESTIMATE BY NEWTON-RAPHSON ITERATION
C
      DO 40 IT=1,MAXIT
      FUNC=GAMIND(ROOT,ALPHA,DLOGG)-F
      RINC=FUNC*DEXP(DLOGG+ROOT-AM1*DLOG(ROOT))
      ROOT=ROOT-RINC
      IF(DABS(FUNC).LE.EPS)GOTO 50
   40 CONTINUE
      WRITE(6,7020)
C
C         SCALE SOLUTION
C
   50 FQUAGAM=ROOT*BETA
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
 1010 WRITE(6,7010)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGAM : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGAM :',
     *  ' ARGUMENT OF FUNCTION INVALID')
 7020 FORMAT(' ** WARNING ** ROUTINE QUAGAM :',
     *  ' ITERATION HAS NOT CONVERGED. RESULT MAY BE UNRELIABLE')
      END
C===================================================== DERF.FOR
      DOUBLE PRECISION FUNCTION DERF(X)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  ERROR FUNCTION
C
C  BASED ON ALGORITHM 5666, J.F.HART ET AL. (1968) 'COMPUTER
C  APPROXIMATIONS'
C
C  ACCURATE TO 15 DECIMAL PLACES
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      DATA ZERO/0D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,FOUR/4D0/,P65/0.65D0/
C
C         COEFFICIENTS OF RATIONAL-FUNCTION APPROXIMATION
C
      DATA P0,P1,P2,P3,P4,P5,P6/
     *  0.22020 68679 12376 1D3,    0.22121 35961 69931 1D3,
     *  0.11207 92914 97870 9D3,    0.33912 86607 83830 0D2,
     *  0.63739 62203 53165 0D1,    0.70038 30644 43688 1D0,
     *  0.35262 49659 98910 9D-1/
      DATA Q0,Q1,Q2,Q3,Q4,Q5,Q6,Q7/
     *  0.44041 37358 24752 2D3,   0.79382 65125 19948 4D3,
     *  0.63733 36333 78831 1D3,   0.29656 42487 79673 7D3,
     *  0.86780 73220 29460 8D2,   0.16064 17757 92069 5D2,
     *  0.17556 67163 18264 2D1,   0.88388 34764 83184 4D-1/
C
C         C1 IS SQRT(2), C2 IS SQRT(2/PI)
C         BIG IS THE POINT AT WHICH DERF=1 TO MACHINE PRECISION
C
      DATA C1/1.4142 13562 37309 5D0/
      DATA C2/7.9788 45608 02865 4D-1/
      DATA BIG/6.25D0/,CRIT/5D0/
C
      DERF=ZERO
      IF(X.EQ.ZERO)RETURN
      XX=DABS(X)
      IF(XX.GT.BIG)GOTO 20
      EXPNTL=DEXP(-X*X)
      ZZ=DABS(X*C1)
      IF(XX.GT.CRIT)GOTO 10
      DERF=EXPNTL*((((((P6*ZZ+P5)*ZZ+P4)*ZZ+P3)*ZZ+P2)*ZZ+P1)*ZZ+P0)/
     *  (((((((Q7*ZZ+Q6)*ZZ+Q5)*ZZ+Q4)*ZZ+Q3)*ZZ+Q2)*ZZ+Q1)*ZZ+Q0)
      IF(X.GT.ZERO)DERF=ONE-TWO*DERF
      IF(X.LT.ZERO)DERF=TWO*DERF-ONE
      RETURN
C
   10 DERF=EXPNTL*C2/(ZZ+ONE/(ZZ+TWO/(ZZ+THREE/(ZZ+FOUR/(ZZ+P65)))))
      IF(X.GT.ZERO)DERF=ONE-DERF
      IF(X.LT.ZERO)DERF=DERF-ONE
      RETURN
C
   20 DERF=ONE
      IF(X.LT.ZERO)DERF=-ONE
      RETURN
      END
C===================================================== DLGAMA.FOR
      DOUBLE PRECISION FUNCTION DLGAMA(X)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  LOGARITHM OF GAMMA FUNCTION
C
C  BASED ON ALGORITHM ACM291, COMMUN. ASSOC. COMPUT. MACH. (1966)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA SMALL,CRIT,BIG,TOOBIG/1D-7,13D0,1D9,2D36/
C
C         C0 IS 0.5*LOG(2*PI)
C         C1...C7 ARE THE COEFFTS OF THE ASYMPTOTIC EXPANSION OF DLGAMA
C
      DATA C0,C1,C2,C3,C4,C5,C6,C7/
     *   0.91893 85332 04672 742D 0,  0.83333 33333 33333 333D-1,
     *  -0.27777 77777 77777 778D-2,  0.79365 07936 50793 651D-3,
     *  -0.59523 80952 38095 238D-3,  0.84175 08417 50841 751D-3,
     *  -0.19175 26917 52691 753D-2,  0.64102 56410 25641 026D-2/
C
C         S1 IS -(EULER'S CONSTANT), S2 IS PI**2/12
C
      DATA S1/-0.57721 56649 01532 861D 0/
      DATA S2/ 0.82246 70334 24113 218D 0/
C
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/
      DLGAMA=ZERO
      IF(X.LE.ZERO)GOTO 1000
      IF(X.GT.TOOBIG)GOTO 1000
C
C         USE SMALL-X APPROXIMATION IF X IS NEAR 0, 1 OR 2
C
      IF(DABS(X-TWO).GT.SMALL)GOTO 10
      DLGAMA=DLOG(X-ONE)
      XX=X-TWO
      GOTO 20
   10 IF(DABS(X-ONE).GT.SMALL)GOTO 30
      XX=X-ONE
   20 DLGAMA=DLGAMA+XX*(S1+XX*S2)
      RETURN
   30 IF(X.GT.SMALL)GOTO 40
      DLGAMA=-DLOG(X)+S1*X
      RETURN
C
C         REDUCE TO DLGAMA(X+N) WHERE X+N.GE.CRIT
C
   40 SUM1=ZERO
      Y=X
      IF(Y.GE.CRIT)GOTO 60
      Z=ONE
   50 Z=Z*Y
      Y=Y+ONE
      IF(Y.LT.CRIT)GOTO 50
      SUM1=SUM1-DLOG(Z)
C
C         USE ASYMPTOTIC EXPANSION IF Y.GE.CRIT
C
   60 SUM1=SUM1+(Y-HALF)*DLOG(Y)-Y+C0
      SUM2=ZERO
      IF(Y.GE.BIG)GOTO 70
      Z=ONE/(Y*Y)
      SUM2=((((((C7*Z+C6)*Z+C5)*Z+C4)*Z+C3)*Z+C2)*Z+C1)/Y
   70 DLGAMA=SUM1+SUM2
      RETURN
C
 1000 WRITE(6,7000)X
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE DLGAMA :',
     *  ' ARGUMENT OUT OF RANGE :',D24.16)
      END
C
C===================================================== QUASTN.FOR
      DOUBLE PRECISION FUNCTION QUASTN(F)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C*  VERSION 3.03  JUNE 2000                                            *
C*  * Fixed: WRITE(6,7000) and FORMAT statement 7000 incompatible      *
C*                                                                     *
C***********************************************************************
C
C  QUANTILE FUNCTION OF THE STANDARD NORMAL DISTRIBUTION
C
C  BASED ON ALGORITHM AS241, APPL. STATIST. (1988) VOL.37 NO.3
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/
      DATA SPLIT1/0.425D0/,SPLIT2/5D0/,CONST1/0.180625D0/,CONST2/1.6D0/
C
C         COEFFICIENTS OF RATIONAL-FUNCTION APPROXIMATIONS
C
      DATA A0,A1,A2,A3,A4,A5,A6,A7,B1,B2,B3,B4,B5,B6,B7/
     *                                0.33871 32872 79636 661D  1,
     *  0.13314 16678 91784 377D  3,  0.19715 90950 30655 144D  4,
     *  0.13731 69376 55094 611D  5,  0.45921 95393 15498 715D  5,
     *  0.67265 77092 70087 009D  5,  0.33430 57558 35881 281D  5,
     *  0.25090 80928 73012 267D  4,  0.42313 33070 16009 113D  2,
     *  0.68718 70074 92057 908D  3,  0.53941 96021 42475 111D  4,
     *  0.21213 79430 15865 959D  5,  0.39307 89580 00927 106D  5,
     *  0.28729 08573 57219 427D  5,  0.52264 95278 85285 456D  4/
      DATA C0,C1,C2,C3,C4,C5,C6,C7,D1,D2,D3,D4,D5,D6,D7/
     *                                0.14234 37110 74968 358D  1,
     *  0.46303 37846 15654 530D  1,  0.57694 97221 46069 141D  1,
     *  0.36478 48324 76320 461D  1,  0.12704 58252 45236 838D  1,
     *  0.24178 07251 77450 612D  0,  0.22723 84498 92691 846D -1,
     *  0.77454 50142 78341 408D -3,  0.20531 91626 63775 882D  1,
     *  0.16763 84830 18380 385D  1,  0.68976 73349 85100 005D  0,
     *  0.14810 39764 27480 075D  0,  0.15198 66656 36164 572D -1,
     *  0.54759 38084 99534 495D -3,  0.10507 50071 64441 684D -8/
      DATA E0,E1,E2,E3,E4,E5,E6,E7,F1,F2,F3,F4,F5,F6,F7/
     *                                0.66579 04643 50110 378D  1,
     *  0.54637 84911 16411 437D  1,  0.17848 26539 91729 133D  1,
     *  0.29656 05718 28504 891D  0,  0.26532 18952 65761 230D -1,
     *  0.12426 60947 38807 844D -2,  0.27115 55568 74348 758D -4,
     *  0.20103 34399 29228 813D -6,  0.59983 22065 55887 938D  0,
     *  0.13692 98809 22735 805D  0,  0.14875 36129 08506 149D -1,
     *  0.78686 91311 45613 259D -3,  0.18463 18317 51005 468D -4,
     *  0.14215 11758 31644 589D -6,  0.20442 63103 38993 979D-14/
C
      Q=F-HALF
      IF(DABS(Q).GT.SPLIT1)GOTO 10
      R=CONST1-Q*Q
      QUASTN=Q*(((((((A7*R+A6)*R+A5)*R+A4)*R+A3)*R+A2)*R+A1)*R+A0)
     *        /(((((((B7*R+B6)*R+B5)*R+B4)*R+B3)*R+B2)*R+B1)*R+ONE)
      RETURN
   10 R=F
      IF(Q.GE.ZERO)R=ONE-F
      IF(R.LE.ZERO)GOTO 1000
      R=DSQRT(-DLOG(R))
      IF(R.GT.SPLIT2)GOTO 20
      R=R-CONST2
      QUASTN=(((((((C7*R+C6)*R+C5)*R+C4)*R+C3)*R+C2)*R+C1)*R+C0)
     *      /(((((((D7*R+D6)*R+D5)*R+D4)*R+D3)*R+D2)*R+D1)*R+ONE)
      GOTO 30
   20 R=R-SPLIT2
      QUASTN=(((((((E7*R+E6)*R+E5)*R+E4)*R+E3)*R+E2)*R+E1)*R+E0)
     *      /(((((((F7*R+F6)*R+F5)*R+F4)*R+F3)*R+F2)*R+F1)*R+ONE)
   30 IF(Q.LT.ZERO)QUASTN=-QUASTN
      RETURN
C
 1000 WRITE(6,7000)
      QUASTN=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUASTN :',
     *  ' ARGUMENT OF FUNCTION INVALID')
      END
C
C===================================================== GAMIND.FOR
      DOUBLE PRECISION FUNCTION GAMIND(X,ALPHA,G)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  THE INCOMPLETE GAMMA INTEGRAL
C
C  BASED ON ALGORITHM AS239, APPL. STATIST. (1988) VOL.37 NO.3
C
C  PARAMETERS OF ROUTINE:
C  X      * INPUT* ARGUMENT OF FUNCTION (UPPER LIMIT OF INTEGRATION)
C  ALPHA  * INPUT* SHAPE PARAMETER
C  G      * INPUT* LOG(GAMMA(ALPHA)). MUST BE SUPPLIED BY THE PROGRAM,
C                  E.G. AS DLGAMA(ALPHA).
C
C  OTHER ROUTINES USED: DERF
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,X13/13D0/,
     *  X36/36D0/,X42/42D0/,X119/119D0/,X1620/1620D0/,X38880/38880D0/,
     *  RTHALF/0.70710 67811 86547 524D0/
C
C         EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF THE SERIES AND
C           CONTINUED-FRACTION EXPANSIONS.
C         OFL IS A LARGE NUMBER, USED TO RESCALE THE CONTINUED FRACTION.
C         UFL IS SUCH THAT EXP(UFL) IS JUST .GT. ZERO.
C         AHILL CONTROLS THE SWITCH TO HILL'S APPROXIMATION.
C
      DATA EPS/1D-12/,MAXIT/100000/,OFL/1D30/,UFL/-180D0/,AHILL/1D4/
      GAMIND=ZERO
      IF(ALPHA.LE.ZERO)GOTO 1000
      IF(X.LT.ZERO)GOTO 1010
      IF(X.EQ.ZERO)RETURN
C
      IF(ALPHA.GT.AHILL)GOTO 100
      IF(X.GT.ONE.AND.X.GE.ALPHA)GOTO 50
C
C         SERIES EXPANSION
C
      SUM=ONE
      TERM=ONE
      A=ALPHA
      DO 10 IT=1,MAXIT
      A=A+ONE
      TERM=TERM*X/A
      SUM=SUM+TERM
      IF(TERM.LE.EPS)GOTO 20
   10 CONTINUE
      WRITE(6,7020)
   20 ARG=ALPHA*DLOG(X)-X-G+DLOG(SUM/ALPHA)
      GAMIND=ZERO
      IF(ARG.GE.UFL)GAMIND=DEXP(ARG)
      RETURN
C
C         CONTINUED-FRACTION EXPANSION
C
   50 CONTINUE
      A=ONE-ALPHA
      B=A+X+ONE
      TERM=ZERO
      PN1=ONE
      PN2=X
      PN3=X+ONE
      PN4=X*B
      RATIO=PN3/PN4
      DO 70 IT=1,MAXIT
      A=A+ONE
      B=B+TWO
      TERM=TERM+ONE
      AN=A*TERM
      PN5=B*PN3-AN*PN1
      PN6=B*PN4-AN*PN2
      IF(PN6.EQ.ZERO)GOTO 60
      RN=PN5/PN6
      DIFF=DABS(RATIO-RN)
      IF(DIFF.LE.EPS.AND.DIFF.LE.EPS*RN)GOTO 80
      RATIO=RN
   60 PN1=PN3
      PN2=PN4
      PN3=PN5
      PN4=PN6
      IF(DABS(PN5).LT.OFL)GOTO 70
      PN1=PN1/OFL
      PN2=PN2/OFL
      PN3=PN3/OFL
      PN4=PN4/OFL
   70 CONTINUE
      WRITE(6,7020)
   80 ARG=ALPHA*DLOG(X)-X-G+DLOG(RATIO)
      GAMIND=ONE
      IF(ARG.GE.UFL)GAMIND=ONE-DEXP(ARG)
      RETURN
C
C         ALPHA IS LARGE: USE HILL'S APPROXIMATION (N.L. JOHNSON AND
C         S. KOTZ, 1970, 'CONTINUOUS UNIVARIATE DISTRIBUTIONS 1', P.180)
C
C         THE 'DO 110' LOOP CALCULATES 2*(X-ALPHA-ALPHA*DLOG(X/ALPHA)),
C         USING POWER-SERIES EXPANSION TO AVOID ROUNDING ERROR
C
  100 CONTINUE
      R=ONE/DSQRT(ALPHA)
      Z=(X-ALPHA)*R
      TERM=Z*Z
      SUM=HALF*TERM
      DO 110 I=1,12
      TERM=-TERM*Z*R
      SUM=SUM+TERM/(I+TWO)
      IF(DABS(TERM).LT.EPS)GOTO 120
  110 CONTINUE
  120 WW=TWO*SUM
      W=DSQRT(WW)
      IF(X.LT.ALPHA)W=-W
      H1=ONE/THREE
      H2=-W/X36
      H3=(-WW+X13)/X1620
      H4=(X42*WW+X119)*W/X38880
      Z=(((H4*R+H3)*R+H2)*R+H1)*R+W
      GAMIND=HALF+HALF*DERF(Z*RTHALF)
      RETURN
C
 1000 WRITE(6,7000)ALPHA
      RETURN
 1010 WRITE(6,7010)X
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE GAMIND :',
     *  ' SHAPE PARAMETER OUT OF RANGE :',D16.8)
 7010 FORMAT(' *** ERROR *** ROUTINE GAMIND :',
     *  ' ARGUMENT OF FUNCTION OUT OF RANGE :',D16.8)
 7020 FORMAT(' ** WARNING ** ROUTINE GAMIND :',
     *  ' ITERATION HAS NOT CONVERGED. RESULT MAY BE UNRELIABLE.')
      END
C===================================================== QUAPE3.FOR
      DOUBLE PRECISION FUNCTION QUAPE3(F,P1,P2,P3)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  QUANTILE FUNCTION OF THE PEARSON TYPE 3 DISTRIBUTION
C
C  OTHER ROUTINES USED: DERF,DLGAMA,GAMIND,QUAGAM,QUASTN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(3),PAR(2)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,FOUR/4D0/
C
C         SMALL IS USED TO TEST WHETHER SKEWNESS IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-6/
	PARA(1)=P1
	PARA(2)=P2
	PARA(3)=P3
C	WRITE(*,*)P1,P2,P3,FC
C     PAUSE
C
      IF(PARA(2).LE.ZERO)GOTO 1000
      GAMMA=PARA(3)
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 20
      IF(DABS(GAMMA).LT.SMALL)GOTO 10
      ALPHA=FOUR/(GAMMA*GAMMA)
      BETA=DABS(HALF*PARA(2)*GAMMA)
      PAR(1)=ALPHA
      PAR(2)=BETA
      IF(GAMMA.GT.ZERO)QUAPE3=PARA(1)-ALPHA*BETA+FQUAGAM(F,ALPHA,BETA)
      IF(GAMMA.LT.ZERO)QUAPE3=PARA(1)+ALPHA*BETA-
	1                        FQUAGAM(ONE-F,ALPHA,BETA)
      RETURN
C
C         ZERO SKEWNESS
C
   10 QUAPE3=PARA(1)+PARA(2)*QUASTN(F)
      RETURN
C
   20 IF(F.EQ.ZERO.AND.GAMMA.GT.ZERO)GOTO 30
      IF(F.EQ.ONE .AND.GAMMA.LT.ZERO)GOTO 30
      WRITE(6,7000)
      QUAPE3=ZERO
      RETURN
   30 QUAPE3=PARA(1)-TWO*PARA(2)/GAMMA
      RETURN
C
 1000 WRITE(6,7010)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAPE3 :',
     *  ' ARGUMENT OF FUNCTION INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAPE3 : PARAMETERS INVALID')
      END
