	PROGRAM MAX_DAY_RAINFALL
	IMPLICIT REAL*8(A-H,O-Z)
	INTEGER :: I, J, K, L, M, N
	REAL :: PSUM
	REAL :: D1, D2, D3, D4, D5
	INTEGER, DIMENSION(50000,3) :: IDA
	REAL, DIMENSION(50000,3) :: P
	INTEGER, DIMENSION(200,9) :: IDMAX
	REAL, DIMENSION (200,3) :: PMAX
	CHARACTER(LEN=50) :: INFILE, OUTFILE
	CHARACTER(LEN=3) :: ISTATION
	
	CALL GETARG(1, INFILE)
	!WRITE (*,*) "INFILE?"
	!READ (*,*) INFILE
	
	CALL GETARG(2, OUTFILE)
	!WRITE (*,*) "OUTFILE?"
	!READ (*,*) OUTFILE

	OPEN(5,FILE=INFILE)
	OPEN(6,FILE=OUTFILE)

	READ (5,*) N
	READ (5,*) IFIRST
	READ (5,*) IEND
		
	DO 100 I=1, N
		READ (5,*) D1, (IDA(I,J),J=1,3), P(I,1)
	100 END DO

	DO 200 I=1,N-2
		P(I,2)=P(I,1)+P(I+1,1)
		P(I,3)=P(I,1)+P(I+1,1)+P(I+2,1)
	200 END DO
	
	IYEAR=1
	D1=0.0;D2=0.0;D3=0.0;D4=0.0;D5=0.0

	DO 300 I=1,N-1
			IF ( (P(I,1)) > D1 ) THEN
				IDMAX(IYEAR,1)=IDA(I,1)
				IDMAX(IYEAR,2)=IDA(I,2)
				IDMAX(IYEAR,3)=IDA(I,3)
				D1=P(I,1)
				PMAX(IYEAR,1)=P(I,1)
			END IF
			IF ( (P(I,2)) > D2 ) THEN
				IDMAX(IYEAR,4)=IDA(I,1)
				IDMAX(IYEAR,5)=IDA(I,2)
				IDMAX(IYEAR,6)=IDA(I,3)
				D2=P(I,2)
				PMAX(IYEAR,2)=P(I,2)
			END IF
			IF ( (P(I,3)) > D3 ) THEN
				IDMAX(IYEAR,7)=IDA(I,1)
				IDMAX(IYEAR,8)=IDA(I,2)
				IDMAX(IYEAR,9)=IDA(I,3)
				D3=P(I,3)
				PMAX(IYEAR,3)=P(I,3)
			END IF
			IF (IDA(I,1) > IFIRST) THEN
				IFIRST=IFIRST+1
				IYEAR=IYEAR+1
				D1=0.0;D2=0.0;D3=0.0;D4=0.0;D5=0.0
			END IF
	300 END DO
	
	DO 350 I=1,IYEAR
		DO 355 J=1,3
			PMAX(I,J)=PMAX(I,J)/1.0
		355 END DO
	350 END DO

	DO 400 I=1,IYEAR
		WRITE (6,1000) IFIRST-IYEAR+I,(PMAX(I,J),J=1,3)
	400 END DO
1000	FORMAT(I8,3F10.1)
	
	WRITE(6,*)

	DO 500 I=1,IYEAR
		WRITE (6,2000) (IDMAX(I,J),J=1,9)
	500 END DO
	
2000	FORMAT(9I10)

	STOP
	END PROGRAM MAX_DAY_RAINFALL